/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.ProjectileEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting.ProjectileAreaTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting.ProjectilePointTarget;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public interface ProjectileTargeting {
    public static final ResourceKey<Registry<MapCodec<? extends ProjectileTargeting>>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)DragonSurvival.res("projectile_targeting"));
    public static final Registry<MapCodec<? extends ProjectileTargeting>> REGISTRY = new RegistryBuilder(REGISTRY_KEY).create();
    public static final Codec<ProjectileTargeting> CODEC = REGISTRY.byNameCodec().dispatch("target_type", ProjectileTargeting::codec, Function.identity());

    public static <T extends ProjectileTargeting> Products.P1<RecordCodecBuilder.Mu<T>, GeneralData> codecStart(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)GeneralData.CODEC.fieldOf("general_data").forGetter(ProjectileTargeting::generalData));
    }

    @SubscribeEvent
    public static void register(NewRegistryEvent event) {
        event.register(REGISTRY);
    }

    @SubscribeEvent
    public static void registerEntries(RegisterEvent event) {
        if (event.getRegistry() == REGISTRY) {
            event.register(REGISTRY_KEY, DragonSurvival.res("area"), () -> ProjectileAreaTarget.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("point"), () -> ProjectilePointTarget.CODEC);
        }
    }

    default public List<MutableComponent> getAllEffectDescriptions(Player dragon, int level) {
        ArrayList<MutableComponent> descriptions = new ArrayList<MutableComponent>();
        MutableComponent targetDescription = this.getDescription(dragon, level);
        for (ConditionalEffect conditional : this.generalData().effects()) {
            List<MutableComponent> effectDescription = conditional.effect().getDescription(dragon, level);
            if (effectDescription.isEmpty()) continue;
            descriptions.addAll(effectDescription.stream().map(description -> ProjectileTargeting.format(description, targetDescription)).toList());
        }
        return descriptions;
    }

    public static MutableComponent format(MutableComponent description, MutableComponent targetDescription) {
        if (targetDescription.getContents() == PlainTextContents.EMPTY) {
            return description;
        }
        return description.append((Component)Component.literal((String)"\n\n")).append((Component)targetDescription);
    }

    public void apply(Projectile var1, int var2);

    public MutableComponent getDescription(Player var1, int var2);

    public MapCodec<? extends ProjectileTargeting> codec();

    public GeneralData generalData();

    public record GeneralData(List<ConditionalEffect> effects, int tickRate, double chance) {
        public static final Codec<GeneralData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ConditionalEffect.CODEC.listOf().fieldOf("effects").forGetter(GeneralData::effects), (App)Codec.INT.optionalFieldOf("tick_rate", (Object)1).forGetter(GeneralData::tickRate), (App)Codec.DOUBLE.optionalFieldOf("chance", (Object)1.0).forGetter(GeneralData::chance)).apply((Applicative)instance, GeneralData::new));
    }

    public record ConditionalEffect(ProjectileEffect<?> effect, Optional<LootItemCondition> condition) {
        public static final Codec<ConditionalEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ProjectileEffect.GENERIC_CODEC.fieldOf("effect").forGetter(ConditionalEffect::effect), (App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("condition").forGetter(ConditionalEffect::condition)).apply((Applicative)instance, ConditionalEffect::new));

        public boolean apply(ServerLevel serverLevel, Projectile projectile, Object target, int level) {
            if (this.condition.map(condition -> condition.test((Object)ConditionalEffect.getContext(serverLevel, projectile, target))).orElse(true).booleanValue()) {
                return this.effect.applyGeneric(projectile, target, level);
            }
            return false;
        }

        private static LootContext getContext(ServerLevel serverLevel, Projectile projectile, Object target) {
            LootContext context;
            if (target instanceof BlockPos) {
                BlockPos position = (BlockPos)target;
                context = ProjectileEffect.positionContext(serverLevel, projectile, position.getCenter());
            } else if (target instanceof Entity) {
                Entity entity = (Entity)target;
                context = ProjectileEffect.entityContext(serverLevel, projectile, entity);
            } else {
                context = ProjectileEffect.positionContext(serverLevel, projectile, projectile.position());
            }
            return context;
        }
    }
}

