/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting.ProjectileTargeting;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;

public record ProjectilePointTarget(ProjectileTargeting.GeneralData generalData) implements ProjectileTargeting
{
    public static final MapCodec<ProjectilePointTarget> CODEC = RecordCodecBuilder.mapCodec(instance -> ProjectileTargeting.codecStart(instance).apply((Applicative)instance, ProjectilePointTarget::new));

    @Override
    public void apply(Projectile projectile, int projectileLevel) {
        if (this.generalData.tickRate() != 0 && (projectile.level().getGameTime() % (long)this.generalData.tickRate() != 0L || this.generalData.chance() < projectile.getRandom().nextDouble())) {
            return;
        }
        this.generalData.effects().forEach(effect -> effect.apply((ServerLevel)projectile.level(), projectile, projectile.blockPosition(), projectileLevel));
    }

    @Override
    public MutableComponent getDescription(Player dragon, int level) {
        MutableComponent description = Component.empty();
        if (this.generalData.tickRate() > 1) {
            description.append((Component)Component.translatable((String)LangKey.ABILITY_X_SECONDS, (Object[])new Object[]{DSColors.dynamicValue(Functions.ticksToSeconds(this.generalData.tickRate()))}));
        }
        return description;
    }

    @Override
    public MapCodec<? extends ProjectileTargeting> codec() {
        return CODEC;
    }
}

