/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting;

import by.dragonsurvivalteam.dragonsurvival.network.particle.SyncParticleTrail;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AbilityTargeting;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AreaTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.TargetingMode;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting.ProjectileTargeting;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public record ProjectileAreaTarget(ProjectileTargeting.GeneralData generalData, LevelBasedValue radius, Optional<ParticleOptions> particleTrail) implements ProjectileTargeting
{
    public static final MapCodec<ProjectileAreaTarget> CODEC = RecordCodecBuilder.mapCodec(instance -> ProjectileTargeting.codecStart(instance).and((App)LevelBasedValue.CODEC.fieldOf("radius").forGetter(ProjectileAreaTarget::radius)).and((App)ParticleTypes.CODEC.optionalFieldOf("particle_trail").forGetter(ProjectileAreaTarget::particleTrail)).apply((Applicative)instance, ProjectileAreaTarget::new));

    @Override
    public void apply(Projectile projectile, int level) {
        if (this.generalData.effects().isEmpty()) {
            return;
        }
        if (this.generalData.tickRate() != 0 && (projectile.level().getGameTime() % (long)this.generalData.tickRate() != 0L || this.generalData.chance() < projectile.getRandom().nextDouble())) {
            return;
        }
        double radius = this.radius.calculate(level);
        ServerLevel serverLevel = (ServerLevel)projectile.level();
        BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)projectile.position(), (double)(radius * 2.0), (double)(radius * 2.0), (double)(radius * 2.0))).forEach(position -> {
            boolean appliedEffect = false;
            for (ProjectileTargeting.ConditionalEffect effect : this.generalData.effects()) {
                if (!effect.apply(serverLevel, projectile, position, level)) continue;
                appliedEffect = true;
            }
            if (appliedEffect) {
                this.handleParticleTrail(projectile, (BlockPos)position, serverLevel);
            }
        });
        serverLevel.getEntities((Entity)projectile, AABB.ofSize((Vec3)projectile.position(), (double)(radius * 2.0), (double)(radius * 2.0), (double)(radius * 2.0))).forEach(entity -> {
            boolean appliedEffect = false;
            for (ProjectileTargeting.ConditionalEffect effect : this.generalData.effects()) {
                if (!effect.apply(serverLevel, projectile, entity, level)) continue;
                appliedEffect = true;
            }
            if (appliedEffect) {
                this.handleParticleTrail(projectile, (Entity)entity, serverLevel);
            }
        });
    }

    private void handleParticleTrail(Projectile projectile, BlockPos position, ServerLevel level) {
        if (this.particleTrail().isEmpty()) {
            return;
        }
        Vec3 trailMidpoint = position.getCenter().subtract(projectile.position()).scale(0.5).add(projectile.position());
        SyncParticleTrail packet = new SyncParticleTrail(projectile.position().toVector3f(), position.getCenter().toVector3f(), this.particleTrail().get());
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)trailMidpoint.x, (double)trailMidpoint.y, (double)trailMidpoint.z, (double)64.0, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void handleParticleTrail(Projectile projectile, Entity entity, ServerLevel level) {
        if (this.particleTrail().isEmpty()) {
            return;
        }
        Vec3 entityMidpoint = entity.position().add(0.0, (double)(entity.getEyeHeight() / 2.0f), 0.0);
        Vec3 trailMidpoint = entityMidpoint.subtract(projectile.position()).scale(0.5).add(projectile.position());
        SyncParticleTrail packet = new SyncParticleTrail(projectile.position().toVector3f(), entityMidpoint.toVector3f(), this.particleTrail().get());
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)trailMidpoint.x, (double)trailMidpoint.y, (double)trailMidpoint.z, (double)64.0, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public MutableComponent getDescription(Player dragon, int level) {
        String radius = AbilityTargeting.FORMAT.format(this.radius.calculate(level));
        MutableComponent description = Component.translatable((String)AreaTarget.AREA_TARGET_ENTITY, (Object[])new Object[]{DSColors.dynamicValue(TargetingMode.ALL.translation()), DSColors.dynamicValue(radius)});
        if (this.generalData.tickRate() > 1) {
            description.append((Component)Component.translatable((String)LangKey.ABILITY_X_SECONDS, (Object[])new Object[]{DSColors.dynamicValue(Functions.ticksToSeconds(this.generalData.tickRate()))}));
        }
        return description;
    }

    @Override
    public MapCodec<? extends ProjectileTargeting> codec() {
        return CODEC;
    }
}

