/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.PotionData;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;

public record ProjectilePotionEffect(PotionData potion) implements ProjectileEntityEffect
{
    public static final MapCodec<ProjectilePotionEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PotionData.CODEC.fieldOf("potion").forGetter(ProjectilePotionEffect::potion)).apply((Applicative)instance, ProjectilePotionEffect::new));

    @Override
    public void apply(Projectile projectile, Entity target, int level) {
        Entity entity = projectile.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            this.potion.apply(serverPlayer, level, target);
        } else {
            this.potion.apply(null, level, target);
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, int level) {
        return this.potion.getDescription(level);
    }

    @Override
    public MapCodec<? extends ProjectileEntityEffect> codec() {
        return CODEC;
    }
}

