/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;

public record ProjectileEntityRunFunctionEffect(ResourceLocation function) implements ProjectileEntityEffect
{
    public static final MapCodec<ProjectileEntityRunFunctionEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("function").forGetter(ProjectileEntityRunFunctionEffect::function)).apply((Applicative)instance, ProjectileEntityRunFunctionEffect::new));

    @Override
    public void apply(Projectile projectile, Entity target, int level) {
        ServerLevel serverLevel = (ServerLevel)projectile.level();
        MinecraftServer server = serverLevel.getServer();
        ServerFunctionManager manager = server.getFunctions();
        manager.get(this.function).ifPresent(source -> {
            CommandSourceStack stack = server.createCommandSourceStack().withPermission(2).withSuppressedOutput().withEntity(target).withLevel(serverLevel).withPosition(target.position()).withRotation(target.getRotationVector());
            manager.execute(source, stack);
        });
    }

    @Override
    public MapCodec<? extends ProjectileEntityEffect> codec() {
        return CODEC;
    }
}

