/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile.block_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.PotionData;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.block_effects.ProjectileBlockEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record ProjectileAreaCloudEffect(PotionData potion, LevelBasedValue duration, LevelBasedValue probability, Optional<LevelBasedValue> delay, Optional<LevelBasedValue> radius, ParticleOptions particle) implements ProjectileBlockEffect
{
    public static final MapCodec<ProjectileAreaCloudEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PotionData.CODEC.fieldOf("potion").forGetter(ProjectileAreaCloudEffect::potion), (App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(ProjectileAreaCloudEffect::duration), (App)LevelBasedValue.CODEC.fieldOf("probability").forGetter(ProjectileAreaCloudEffect::probability), (App)LevelBasedValue.CODEC.optionalFieldOf("delay").forGetter(ProjectileAreaCloudEffect::delay), (App)LevelBasedValue.CODEC.optionalFieldOf("radius").forGetter(ProjectileAreaCloudEffect::radius), (App)ParticleTypes.CODEC.fieldOf("particle").forGetter(ProjectileAreaCloudEffect::particle)).apply((Applicative)instance, ProjectileAreaCloudEffect::new));

    @Override
    public void apply(Projectile projectile, BlockPos target, int level) {
        if (projectile.level().random.nextDouble() < (double)this.probability.calculate(level)) {
            AreaEffectCloud cloud = new AreaEffectCloud(projectile.level(), (double)target.getX(), projectile.level().getBlockState(target.below()).isSolid() ? (double)target.above().getY() : (double)target.getY(), (double)target.getZ());
            Entity entity = projectile.getOwner();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                cloud.setPotionContents(this.potion.toPotionContents(serverPlayer.getRandom(), level));
            } else {
                cloud.setPotionContents(this.potion.toPotionContents(projectile.getRandom(), level));
            }
            cloud.setDuration((int)this.duration.calculate(level));
            cloud.setParticle(this.particle);
            entity = projectile.getOwner();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                cloud.setOwner(living);
            }
            cloud.setWaitTime((int)this.delay.orElse((LevelBasedValue)LevelBasedValue.constant((float)0.0f)).calculate(level));
            cloud.setRadius(this.radius.orElse((LevelBasedValue)LevelBasedValue.constant((float)1.0f)).calculate(level));
            projectile.level().addFreshEntity((Entity)cloud);
        }
    }

    @Override
    public MapCodec<? extends ProjectileBlockEffect> codec() {
        return CODEC;
    }
}

