/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile;

import by.dragonsurvivalteam.dragonsurvival.registry.projectile.block_effects.ProjectileBlockEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.world_effects.ProjectileWorldEffect;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public interface ProjectileEffect<T> {
    public static final LootContextParamSet POSITION_CONTEXT = new LootContextParamSet.Builder().required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.BLOCK_STATE).build();
    public static final LootContextParamSet ENTITY_CONTEXT = new LootContextParamSet.Builder().required(LootContextParams.THIS_ENTITY).required(LootContextParams.ATTACKING_ENTITY).required(LootContextParams.ORIGIN).build();
    public static final Codec<ProjectileEffect<?>> GENERIC_CODEC = Codec.either(ProjectileBlockEffect.CODEC, (Codec)Codec.either(ProjectileEntityEffect.CODEC, ProjectileWorldEffect.CODEC)).flatXmap(either -> (DataResult)either.map(DataResult::success, other -> (DataResult)other.map(DataResult::success, DataResult::success)), effect -> {
        if (effect instanceof ProjectileBlockEffect) {
            ProjectileBlockEffect blockEffect = (ProjectileBlockEffect)effect;
            return DataResult.success((Object)Either.left((Object)blockEffect));
        }
        if (effect instanceof ProjectileEntityEffect) {
            ProjectileEntityEffect entityEffect = (ProjectileEntityEffect)effect;
            return DataResult.success((Object)Either.right((Object)Either.left((Object)entityEffect)));
        }
        if (effect instanceof ProjectileWorldEffect) {
            ProjectileWorldEffect worldEffect = (ProjectileWorldEffect)effect;
            return DataResult.success((Object)Either.right((Object)Either.right((Object)worldEffect)));
        }
        return DataResult.error(() -> "Invalid ProjectileEffect type: [" + effect.getClass().getName() + "]");
    });

    public static LootContext positionContext(ServerLevel level, Projectile projectile, Vec3 origin) {
        LootParams parameters = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)projectile).withParameter(LootContextParams.ORIGIN, (Object)origin).withParameter(LootContextParams.BLOCK_STATE, (Object)level.getBlockState(BlockPos.containing((Position)origin))).create(POSITION_CONTEXT);
        return new LootContext.Builder(parameters).create(Optional.empty());
    }

    public static LootContext entityContext(ServerLevel level, Projectile projectile, Entity target) {
        LootParams parameters = new LootParams.Builder(level).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)projectile).withParameter(LootContextParams.THIS_ENTITY, (Object)target).withParameter(LootContextParams.ORIGIN, (Object)target.position()).create(ENTITY_CONTEXT);
        return new LootContext.Builder(parameters).create(Optional.empty());
    }

    default public boolean applyGeneric(Projectile projectile, Object target, int level) {
        ProjectileEffect projectileEffect;
        ProjectileEffect projectileEffect2 = this;
        if (projectileEffect2 instanceof ProjectileBlockEffect) {
            ProjectileBlockEffect blockEffect = (ProjectileBlockEffect)projectileEffect2;
            if (target instanceof BlockPos) {
                BlockPos position = (BlockPos)target;
                blockEffect.apply(projectile, position, level);
                return true;
            }
        }
        if ((projectileEffect2 = this) instanceof ProjectileEntityEffect) {
            ProjectileEntityEffect entityEffect = (ProjectileEntityEffect)projectileEffect2;
            if (target instanceof Entity) {
                Entity entity = (Entity)target;
                entityEffect.apply(projectile, entity, level);
                return true;
            }
        }
        if ((projectileEffect = this) instanceof ProjectileWorldEffect) {
            ProjectileWorldEffect worldEffect = (ProjectileWorldEffect)projectileEffect;
            worldEffect.apply(projectile, null, level);
            return true;
        }
        return false;
    }

    default public List<MutableComponent> getDescription(Player dragon, int level) {
        return List.of();
    }

    public void apply(Projectile var1, T var2, int var3);

    public MapCodec<? extends ProjectileEffect<T>> codec();
}

