/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.projectile;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.LevelBasedResource;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.block_effects.ProjectileBlockEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.entity_effects.ProjectileEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.targeting.ProjectileTargeting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ProjectileData(GeneralData generalData, Either<GenericBallData, GenericArrowData> typeData) {
    public static final ResourceKey<Registry<ProjectileData>> REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)DragonSurvival.res("projectile_data"));
    public static final Codec<ProjectileData> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GeneralData.CODEC.fieldOf("general_data").forGetter(ProjectileData::generalData), (App)Codec.either(GenericBallData.CODEC, GenericArrowData.CODEC).fieldOf("type_data").forGetter(ProjectileData::typeData)).apply((Applicative)instance, ProjectileData::new));
    public static final Codec<Holder<ProjectileData>> CODEC = RegistryFixedCodec.create(REGISTRY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<ProjectileData>> STREAM_CODEC = ByteBufCodecs.holderRegistry(REGISTRY);

    @SubscribeEvent
    public static void register(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(REGISTRY, DIRECT_CODEC, DIRECT_CODEC);
    }

    public record GeneralData(ResourceLocation name, Optional<LootItemCondition> entityHitCondition, List<ProjectileTargeting> tickingEffects, List<ProjectileTargeting> commonHitEffects, List<ProjectileEntityEffect> entityHitEffects, List<ProjectileBlockEffect> blockHitEffects) {
        public static final Codec<GeneralData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("name").forGetter(GeneralData::name), (App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("entity_hit_condition").forGetter(GeneralData::entityHitCondition), (App)ProjectileTargeting.CODEC.listOf().fieldOf("ticking_effects").forGetter(GeneralData::tickingEffects), (App)ProjectileTargeting.CODEC.listOf().fieldOf("common_hit_effects").forGetter(GeneralData::commonHitEffects), (App)ProjectileEntityEffect.CODEC.listOf().fieldOf("entity_hit_effects").forGetter(GeneralData::entityHitEffects), (App)ProjectileBlockEffect.CODEC.listOf().fieldOf("block_hit_effects").forGetter(GeneralData::blockHitEffects)).apply((Applicative)instance, GeneralData::new));
    }

    public record GenericBallData(LevelBasedResource resources, Optional<ParticleOptions> trailParticle, List<ProjectileTargeting> onDestroyEffects, BehaviourData behaviourData) {
        public static final Codec<GenericBallData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LevelBasedResource.CODEC.fieldOf("resources").forGetter(GenericBallData::resources), (App)ParticleTypes.CODEC.optionalFieldOf("trail_particle").forGetter(GenericBallData::trailParticle), (App)ProjectileTargeting.CODEC.listOf().optionalFieldOf("on_destroy_effects", List.of()).forGetter(GenericBallData::onDestroyEffects), (App)BehaviourData.CODEC.fieldOf("behaviour_data").forGetter(GenericBallData::behaviourData)).apply((Applicative)instance, GenericBallData::new));
    }

    public record GenericArrowData(LevelBasedResource texture, LevelBasedValue piercingLevel) {
        public static final Codec<GenericArrowData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LevelBasedResource.CODEC.fieldOf("texture").forGetter(GenericArrowData::texture), (App)LevelBasedValue.CODEC.optionalFieldOf("piercing_level", (Object)LevelBasedValue.constant((float)0.0f)).forGetter(GenericArrowData::piercingLevel)).apply((Applicative)instance, GenericArrowData::new));
    }

    public record BehaviourData(LevelBasedValue width, LevelBasedValue height, LevelBasedValue maxBounces, LevelBasedValue maxLingeringTicks, LevelBasedValue maxMovementDistance, LevelBasedValue maxLifespan) {
        public static final Codec<BehaviourData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("width").forGetter(BehaviourData::width), (App)LevelBasedValue.CODEC.fieldOf("height").forGetter(BehaviourData::height), (App)LevelBasedValue.CODEC.optionalFieldOf("max_bounces", (Object)LevelBasedValue.constant((float)0.0f)).forGetter(BehaviourData::maxBounces), (App)LevelBasedValue.CODEC.optionalFieldOf("max_lingering_ticks", (Object)LevelBasedValue.constant((float)0.0f)).forGetter(BehaviourData::maxLingeringTicks), (App)LevelBasedValue.CODEC.fieldOf("max_movement_distance").forGetter(BehaviourData::maxMovementDistance), (App)LevelBasedValue.CODEC.fieldOf("max_lifespan").forGetter(BehaviourData::maxLifespan)).apply((Applicative)instance, BehaviourData::new));
    }
}

