/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Fear;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.CommonData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FearData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record FearPenalty(List<Fear> fears) implements PenaltyEffect
{
    public static final MapCodec<FearPenalty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Fear.CODEC.listOf().fieldOf("fears").forGetter(FearPenalty::fears)).apply((Applicative)instance, FearPenalty::new));

    @Override
    public void apply(ServerPlayer player, Holder<DragonPenalty> penalty) {
        FearData data = (FearData)player.getData(DSDataAttachments.FEAR);
        int growth = (int)DragonStateProvider.getData((Player)player).getGrowth();
        this.fears.forEach(fear -> {
            Fear.Instance instance = (Fear.Instance)data.get(fear.id());
            int newDuration = (int)fear.duration().calculate(1);
            int newDistance = (int)fear.distance().calculate(growth);
            float newWalkSpeed = fear.walkSpeed().calculate(growth);
            float newSprintSpeed = fear.sprintSpeed().calculate(growth);
            if (instance != null && instance.currentDuration() == newDuration && instance.distance() == newDistance && instance.walkSpeed() == newWalkSpeed && instance.sprintSpeed() == newSprintSpeed) {
                return;
            }
            data.remove((Entity)player, instance);
            data.add((Entity)player, new Fear.Instance((Fear)fear, CommonData.from(fear.id(), player, penalty, Optional.empty(), fear.shouldRemoveAutomatically()), newDuration, newDistance, newWalkSpeed, newSprintSpeed));
        });
    }

    @Override
    public MapCodec<? extends PenaltyEffect> codec() {
        return CODEC;
    }
}

