/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;

public record DamagePenalty(Holder<DamageType> damageType, float damage) implements PenaltyEffect
{
    public static final MapCodec<DamagePenalty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DamageType.CODEC.fieldOf("damage_type").forGetter(DamagePenalty::damageType), (App)Codec.FLOAT.fieldOf("amount").forGetter(DamagePenalty::damage)).apply((Applicative)instance, DamagePenalty::new));

    @Override
    public void apply(ServerPlayer player, Holder<DragonPenalty> penalty) {
        player.hurt(new DamageSource(this.damageType, (Entity)null), this.damage);
    }

    @Override
    public MutableComponent getDescription() {
        MutableComponent translation = Component.translatable((String)Translation.Type.DAMAGE_TYPE.wrap(this.damageType.getKey().location())).withColor(0xFFAA00);
        return Component.translatable((String)LangKey.ABILITY_DAMAGE, (Object[])new Object[]{translation, DSColors.dynamicValue(String.format("%.1f", Float.valueOf(this.damage)))});
    }

    @Override
    public MapCodec<? extends PenaltyEffect> codec() {
        return CODEC;
    }
}

