/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncAbilityLevel;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.ConditionUpgrade;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.DragonGrowthUpgrade;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.ExperienceLevelUpgrade;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.ExperiencePointsUpgrade;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.ItemUpgrade;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public interface UpgradeType<T> {
    public static final ResourceKey<Registry<MapCodec<? extends UpgradeType<?>>>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)DragonSurvival.res("upgrade_type"));
    public static final Registry<MapCodec<? extends UpgradeType<?>>> REGISTRY = new RegistryBuilder(REGISTRY_KEY).create();
    public static final Codec<UpgradeType<?>> CODEC = REGISTRY.byNameCodec().dispatch("upgrade_type", UpgradeType::codec, Function.identity());
    public static final Predicate<Optional<UpgradeType<?>>> IS_MANUAL = optional -> optional.isPresent() && optional.get() instanceof ExperiencePointsUpgrade;

    @SubscribeEvent
    public static void register(NewRegistryEvent event) {
        event.register(REGISTRY);
    }

    @SubscribeEvent
    public static void registerEntries(RegisterEvent event) {
        if (event.getRegistry() == REGISTRY) {
            event.register(REGISTRY_KEY, DragonSurvival.res("experience_points"), () -> ExperiencePointsUpgrade.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("experience_levels"), () -> ExperienceLevelUpgrade.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("dragon_growth"), () -> DragonGrowthUpgrade.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("item_based"), () -> ItemUpgrade.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("condition_based"), () -> ConditionUpgrade.CODEC);
        }
    }

    public static <V extends UpgradeType<?>> Products.P1<RecordCodecBuilder.Mu<V>, Integer> codecStart(RecordCodecBuilder.Instance<V> instance) {
        return instance.group((App)ExtraCodecs.intRange((int)0, (int)255).fieldOf("maximum_level").forGetter(UpgradeType::maxLevel));
    }

    default public boolean attempt(ServerPlayer dragon, DragonAbilityInstance ability, @Nullable Object input) {
        Type[] interfaces;
        for (Type type : interfaces = this.getClass().getGenericInterfaces()) {
            ParameterizedType parameterized;
            if (!(type instanceof ParameterizedType) || (parameterized = (ParameterizedType)type).getRawType() != UpgradeType.class) continue;
            Class parameterClass = (Class)parameterized.getActualTypeArguments()[0];
            if ((input != null || parameterClass != Void.class) && !parameterClass.isInstance(input) || !this.apply(dragon, ability, input)) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)dragon, (CustomPacketPayload)new SyncAbilityLevel(ability.key(), ability.level()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return false;
    }

    default public boolean canUpgrade(ServerPlayer dragon, DragonAbilityInstance ability) {
        return ability.level() < this.maxLevel();
    }

    default public boolean canDowngrade(ServerPlayer dragon, DragonAbilityInstance ability) {
        return ability.level() > this.minLevel();
    }

    default public int minLevel() {
        return 0;
    }

    public boolean apply(ServerPlayer var1, DragonAbilityInstance var2, T var3);

    public MutableComponent getDescription(int var1);

    public int maxLevel();

    public MapCodec<? extends UpgradeType<?>> codec();
}

