/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.InputData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.UpgradeType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record DragonGrowthUpgrade(int maxLevel, LevelBasedValue growthRequirement) implements UpgradeType<InputData>
{
    @Translation(comments={"\u00a76\u25a0 Next level will be unlocked at growth %s"})
    private static final String DRAGON_SIZE_UPGRADE = Translation.Type.GUI.wrap("ability_upgrade.dragon_growth_upgrade");
    public static final MapCodec<DragonGrowthUpgrade> CODEC = RecordCodecBuilder.mapCodec(instance -> UpgradeType.codecStart(instance).and((App)LevelBasedValue.CODEC.fieldOf("growth_requirement").forGetter(DragonGrowthUpgrade::growthRequirement)).apply((Applicative)instance, DragonGrowthUpgrade::new));

    @Override
    public boolean apply(ServerPlayer dragon, DragonAbilityInstance ability, InputData data) {
        if (data.type() != InputData.Type.GROWTH) {
            return false;
        }
        int newLevel = 0;
        for (int level = 1; level <= this.maxLevel() && !((float)data.input().intValue() < this.growthRequirement.calculate(level)); ++level) {
            ++newLevel;
        }
        if (newLevel != ability.level()) {
            ability.setLevel(newLevel);
            return true;
        }
        return false;
    }

    @Override
    public MutableComponent getDescription(int abilityLevel) {
        return Component.translatable((String)DRAGON_SIZE_UPGRADE, (Object[])new Object[]{(int)this.growthRequirement.calculate(abilityLevel)});
    }

    @Override
    public MapCodec<? extends UpgradeType<?>> codec() {
        return CODEC;
    }
}

