/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.UpgradeType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record ConditionUpgrade(List<LootItemCondition> conditions, boolean requirePrevious) implements UpgradeType<Void>
{
    public static final MapCodec<ConditionUpgrade> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootItemCondition.DIRECT_CODEC.listOf().fieldOf("conditions").forGetter(ConditionUpgrade::conditions), (App)Codec.BOOL.optionalFieldOf("require_previous", (Object)true).forGetter(ConditionUpgrade::requirePrevious)).apply((Applicative)instance, ConditionUpgrade::new));
    private static final LootContextParamSet CONTEXT = new LootContextParamSet.Builder().required(LootContextParams.THIS_ENTITY).required(LootContextParams.ORIGIN).required(LootContextParams.TOOL).build();

    @Override
    public boolean apply(ServerPlayer dragon, DragonAbilityInstance ability, Void ignored) {
        LootContext context = this.createContext(dragon);
        int newLevel = 0;
        for (int level = 1; level <= this.maxLevel(); ++level) {
            if (!this.conditions.get(level - 1).test((Object)context)) {
                if (!this.requirePrevious) continue;
                break;
            }
            if (this.requirePrevious) {
                ++newLevel;
                continue;
            }
            newLevel = level;
        }
        if (newLevel != ability.level()) {
            ability.setLevel(newLevel);
            return true;
        }
        return false;
    }

    private LootContext createContext(ServerPlayer dragon) {
        LootParams parameters = new LootParams.Builder(dragon.serverLevel()).withParameter(LootContextParams.THIS_ENTITY, (Object)dragon).withParameter(LootContextParams.ORIGIN, (Object)dragon.position()).withParameter(LootContextParams.TOOL, (Object)dragon.getMainHandItem()).create(CONTEXT);
        return new LootContext.Builder(parameters).create(Optional.empty());
    }

    @Override
    public MutableComponent getDescription(int abilityLevel) {
        return Component.empty();
    }

    @Override
    public int maxLevel() {
        return this.conditions.size();
    }

    @Override
    public MapCodec<? extends UpgradeType<?>> codec() {
        return CODEC;
    }
}

