/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting;

import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AbilityTargeting;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record DragonBreathTarget(Either<AbilityTargeting.BlockTargeting, AbilityTargeting.EntityTargeting> target, LevelBasedValue rangeMultiplier) implements AbilityTargeting
{
    @Translation(comments={"Targets a %s block cone"})
    private static final String CONE_TARGET_BLOCK = Translation.Type.GUI.wrap("ability_target.cone_target.block");
    @Translation(comments={"Targets %s in a %s block cone"})
    private static final String CONE_TARGET_ENTITY = Translation.Type.GUI.wrap("ability_target.cone_target.entity");
    public static final MapCodec<DragonBreathTarget> CODEC = RecordCodecBuilder.mapCodec(instance -> AbilityTargeting.codecStart(instance).and((App)LevelBasedValue.CODEC.fieldOf("range_multiplier").forGetter(DragonBreathTarget::rangeMultiplier)).apply((Applicative)instance, DragonBreathTarget::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability) {
        this.target().ifLeft(blockTarget -> {
            Direction direction = Direction.getNearest((Vec3)dragon.getEyePosition());
            BlockPos.betweenClosedStream((AABB)this.calculateBreathArea((Player)dragon, ability)).forEach(position -> {
                if (blockTarget.matches(dragon, (BlockPos)position)) {
                    blockTarget.effects().forEach(target -> target.apply(dragon, ability, (BlockPos)position, direction));
                }
            });
        }).ifRight(entityTarget -> dragon.serverLevel().getEntities(EntityTypeTest.forClass(Entity.class), this.calculateBreathArea((Player)dragon, ability), entity -> entityTarget.targetingMode().isEntityRelevant((Player)dragon, (Entity)entity) && entityTarget.matches(dragon, (Entity)entity, entity.position())).forEach(entity -> entityTarget.effects().forEach(target -> target.apply(dragon, ability, (Entity)entity))));
    }

    @Override
    public MutableComponent getDescription(Player dragon, DragonAbilityInstance ability) {
        Component targetingComponent = (Component)this.target.map(block -> null, entity -> entity.targetingMode().translation());
        MutableComponent range = DSColors.dynamicValue(FORMAT.format(this.getRange(dragon, ability)));
        if (targetingComponent == null) {
            return Component.translatable((String)CONE_TARGET_BLOCK, (Object[])new Object[]{range});
        }
        return Component.translatable((String)CONE_TARGET_ENTITY, (Object[])new Object[]{DSColors.dynamicValue(targetingComponent), range});
    }

    public AABB calculateBreathArea(Player dragon, DragonAbilityInstance ability) {
        Vec3 viewVector = dragon.getLookAngle().scale((double)this.rangeMultiplier.calculate(ability.level()) * dragon.getAttributeValue(DSAttributes.DRAGON_BREATH_RANGE));
        double defaultRadius = dragon.getScale();
        double xOffset = DragonBreathTarget.getOffset(viewVector.x(), defaultRadius);
        double yOffset = Math.abs(viewVector.y());
        double zOffset = DragonBreathTarget.getOffset(viewVector.z(), defaultRadius);
        double xMin = dragon.getLookAngle().x() < 0.0 ? xOffset : defaultRadius;
        double yMin = dragon.getLookAngle().y() < 0.0 ? yOffset : 0.0;
        double zMin = dragon.getLookAngle().z() < 0.0 ? zOffset : defaultRadius;
        Vec3 min = new Vec3(Math.abs(xMin), Math.abs(yMin), Math.abs(zMin));
        double xMax = dragon.getLookAngle().x() > 0.0 ? xOffset : defaultRadius;
        double yMax = dragon.getLookAngle().y() > 0.0 ? yOffset + (double)dragon.getEyeHeight() : (double)dragon.getEyeHeight();
        double zMax = dragon.getLookAngle().z() > 0.0 ? zOffset : defaultRadius;
        Vec3 max = new Vec3(Math.abs(xMax), Math.abs(yMax), Math.abs(zMax));
        Vec3 startPosition = dragon.getEyePosition().subtract(0.0, (double)(dragon.getEyeHeight() / 2.0f), 0.0);
        return new AABB(startPosition.subtract(min), startPosition.add(max));
    }

    private float getRange(Player dragon, DragonAbilityInstance ability) {
        return (float)((double)this.rangeMultiplier.calculate(ability.level()) * dragon.getAttributeValue(DSAttributes.DRAGON_BREATH_RANGE));
    }

    private static double getOffset(double value, double defaultValue) {
        if (value < 0.0) {
            return Math.min(value, -defaultValue);
        }
        return Math.max(value, defaultValue);
    }

    @Override
    public MapCodec<? extends AbilityTargeting> codec() {
        return CODEC;
    }
}

