/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AbilityTargeting;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record AreaTarget(Either<AbilityTargeting.BlockTargeting, AbilityTargeting.EntityTargeting> target, LevelBasedValue radius) implements AbilityTargeting
{
    @Translation(comments={"Targets a %s block radius"})
    private static final String AREA_TARGET_BLOCK = Translation.Type.GUI.wrap("ability_target.area_target.block");
    @Translation(comments={"Targets %s in a %s block radius"})
    public static final String AREA_TARGET_ENTITY = Translation.Type.GUI.wrap("ability_target.area_target.entity");
    public static final MapCodec<AreaTarget> CODEC = RecordCodecBuilder.mapCodec(instance -> AbilityTargeting.codecStart(instance).and((App)LevelBasedValue.CODEC.fieldOf("radius").forGetter(AreaTarget::radius)).apply((Applicative)instance, AreaTarget::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability) {
        this.target().ifLeft(blockTarget -> BlockPos.betweenClosedStream((AABB)this.calculateAffectedArea((Player)dragon, ability)).forEach(position -> {
            if (blockTarget.matches(dragon, (BlockPos)position)) {
                blockTarget.effects().forEach(target -> target.apply(dragon, ability, (BlockPos)position, null));
            }
        })).ifRight(entityTarget -> dragon.serverLevel().getEntities(EntityTypeTest.forClass(Entity.class), this.calculateAffectedArea((Player)dragon, ability), entity -> entityTarget.targetingMode().isEntityRelevant((Player)dragon, (Entity)entity) && entityTarget.matches(dragon, (Entity)entity, entity.position())).forEach(entity -> entityTarget.effects().forEach(target -> target.apply(dragon, ability, (Entity)entity))));
    }

    @Override
    public MutableComponent getDescription(Player dragon, DragonAbilityInstance ability) {
        Component targetingComponent = (Component)this.target.map(block -> null, entity -> entity.targetingMode().translation());
        MutableComponent area = DSColors.dynamicValue(FORMAT.format(this.getArea(ability)));
        if (targetingComponent == null) {
            return Component.translatable((String)AREA_TARGET_BLOCK, (Object[])new Object[]{area});
        }
        return Component.translatable((String)AREA_TARGET_ENTITY, (Object[])new Object[]{DSColors.dynamicValue(targetingComponent), area});
    }

    private float getArea(DragonAbilityInstance ability) {
        return this.radius().calculate(ability.level());
    }

    public AABB calculateAffectedArea(Player dragon, DragonAbilityInstance ability) {
        double radius = this.radius().calculate(ability.level());
        return AABB.ofSize((Vec3)dragon.position(), (double)(radius * 2.0), (double)(radius * 2.0), (double)(radius * 2.0));
    }

    @Override
    public MapCodec<? extends AbilityTargeting> codec() {
        return CODEC;
    }
}

