/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects.AbilityBlockEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AreaTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.DiscTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.DragonBreathTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.LookingAtTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.SelfTarget;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.TargetingMode;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public interface AbilityTargeting {
    public static final String EFFECT_HEADER = "#HEADER#";
    public static final NumberFormat FORMAT = Functions.getFormat(2);
    public static final ResourceKey<Registry<MapCodec<? extends AbilityTargeting>>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)DragonSurvival.res("ability_targeting"));
    public static final Registry<MapCodec<? extends AbilityTargeting>> REGISTRY = new RegistryBuilder(REGISTRY_KEY).create();
    public static final Codec<AbilityTargeting> CODEC = REGISTRY.byNameCodec().dispatch("target_type", AbilityTargeting::codec, Function.identity());

    public static Either<BlockTargeting, EntityTargeting> block(List<AbilityBlockEffect> effects) {
        return AbilityTargeting.block(null, effects);
    }

    public static Either<BlockTargeting, EntityTargeting> block(LootItemCondition targetConditions, List<AbilityBlockEffect> effects) {
        return Either.left((Object)new BlockTargeting(Optional.ofNullable(targetConditions), effects));
    }

    public static Either<BlockTargeting, EntityTargeting> entity(List<AbilityEntityEffect> effects, TargetingMode targetingMode) {
        return AbilityTargeting.entity(null, effects, targetingMode);
    }

    public static Either<BlockTargeting, EntityTargeting> entity(LootItemCondition targetConditions, List<AbilityEntityEffect> effects, TargetingMode targetingMode) {
        return Either.right((Object)new EntityTargeting(Optional.ofNullable(targetConditions), effects, targetingMode));
    }

    public static <T extends AbilityTargeting> Products.P1<RecordCodecBuilder.Mu<T>, Either<BlockTargeting, EntityTargeting>> codecStart(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)Codec.either(BlockTargeting.CODEC, EntityTargeting.CODEC).fieldOf("applied_effects").forGetter(AbilityTargeting::target));
    }

    @SubscribeEvent
    public static void register(NewRegistryEvent event) {
        event.register(REGISTRY);
    }

    @SubscribeEvent
    public static void registerEntries(RegisterEvent event) {
        if (event.getRegistry() == REGISTRY) {
            event.register(REGISTRY_KEY, DragonSurvival.res("area"), () -> AreaTarget.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("dragon_breath"), () -> DragonBreathTarget.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("looking_at"), () -> LookingAtTarget.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("self"), () -> SelfTarget.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("disc"), () -> DiscTarget.CODEC);
        }
    }

    default public List<MutableComponent> getAllEffectDescriptions(Player dragon, DragonAbilityInstance ability) {
        if (!ability.isUsable()) {
            return List.of();
        }
        ArrayList<MutableComponent> descriptions = new ArrayList<MutableComponent>();
        MutableComponent targetDescription = this.getDescription(dragon, ability);
        this.target().ifLeft(blockTargeting -> blockTargeting.effects().forEach(effect -> {
            List<MutableComponent> abilityEffectDescriptions = effect.getDescription(dragon, ability);
            if (!effect.getDescription(dragon, ability).isEmpty()) {
                descriptions.addAll(abilityEffectDescriptions.stream().map(description -> this.format((MutableComponent)description, targetDescription)).toList());
            }
        })).ifRight(entityTargeting -> entityTargeting.effects().forEach(effect -> {
            List<MutableComponent> abilityEffectDescriptions = effect.getDescription(dragon, ability);
            if (!effect.getDescription(dragon, ability).isEmpty()) {
                if (this instanceof SelfTarget) {
                    descriptions.addAll(effect.getDescription(dragon, ability).stream().map(this::format).toList());
                } else {
                    descriptions.addAll(abilityEffectDescriptions.stream().map(description -> this.format((MutableComponent)description, targetDescription)).toList());
                }
            }
        }));
        return descriptions;
    }

    private MutableComponent format(MutableComponent description) {
        return Component.literal((String)EFFECT_HEADER).append((Component)Component.literal((String)"\n")).append((Component)description);
    }

    private MutableComponent format(MutableComponent description, MutableComponent targetDescription) {
        return this.format(description).append((Component)Component.literal((String)"\n\n")).append((Component)targetDescription);
    }

    default public void remove(ServerPlayer dragon, DragonAbilityInstance ability) {
    }

    public MutableComponent getDescription(Player var1, DragonAbilityInstance var2);

    public void apply(ServerPlayer var1, DragonAbilityInstance var2);

    public MapCodec<? extends AbilityTargeting> codec();

    public Either<BlockTargeting, EntityTargeting> target();

    public record BlockTargeting(Optional<LootItemCondition> targetConditions, List<AbilityBlockEffect> effects) {
        public static final Codec<BlockTargeting> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("target_conditions").forGetter(BlockTargeting::targetConditions), (App)AbilityBlockEffect.CODEC.listOf().fieldOf("block_effect").forGetter(BlockTargeting::effects)).apply((Applicative)instance, BlockTargeting::new));

        public boolean matches(ServerPlayer dragon, BlockPos position) {
            return this.targetConditions.map(condition -> condition.test((Object)Condition.blockContext(dragon, position))).orElse(true);
        }
    }

    public record EntityTargeting(Optional<LootItemCondition> targetConditions, List<AbilityEntityEffect> effects, TargetingMode targetingMode) {
        public static final Codec<EntityTargeting> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("target_conditions").forGetter(EntityTargeting::targetConditions), (App)AbilityEntityEffect.CODEC.listOf().fieldOf("entity_effect").forGetter(EntityTargeting::effects), (App)TargetingMode.CODEC.fieldOf("targeting_mode").forGetter(EntityTargeting::targetingMode)).apply((Applicative)instance, EntityTargeting::new));

        public boolean matches(ServerPlayer dragon, Entity entity, Vec3 position) {
            return this.targetConditions.map(condition -> condition.test((Object)Condition.abilityContext(dragon, entity, position))).orElse(true);
        }
    }
}

