/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.OnAttackEffectInstance;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.PotionData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.OnAttackEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record OnAttackEffect(PotionData potionData) implements AbilityEntityEffect
{
    public static final MapCodec<OnAttackEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PotionData.CODEC.fieldOf("potion").forGetter(OnAttackEffect::potionData)).apply((Applicative)instance, OnAttackEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        OnAttackEffects data = OnAttackEffects.getData(target);
        PotionData.Calculated calculated = PotionData.Calculated.from(this.potionData, ability.level());
        data.addEffect(ability.id(), new OnAttackEffectInstance(this.potionData.effects(), calculated.amplifier(), calculated.duration(), calculated.probability()));
    }

    @Override
    public void remove(ServerPlayer dragon, DragonAbilityInstance ability, Entity entity, boolean isAutoRemoval) {
        if (isAutoRemoval) {
            return;
        }
        OnAttackEffects.getData(entity).removeEffect(ability.id());
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        List<MutableComponent> description = this.potionData.getDescription(ability.level());
        for (MutableComponent component : description) {
            component.append((Component)Component.translatable((String)LangKey.ABILITY_ON_HIT));
        }
        return description;
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

