/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record MobEffectRemovalEffect(Optional<List<MobEffectCategory>> categories, Optional<HolderSet<MobEffect>> validEffects, Optional<LevelBasedValue> maxAmount, Optional<LevelBasedValue> maximumEffectLevel) implements AbilityEntityEffect
{
    @Translation(comments={"Removes %s effect"})
    public static final String REMOVE_ONE = Translation.Type.GUI.wrap("mobeffect_removal_effect.remove_one");
    @Translation(comments={"Removes %s status effects"})
    public static final String REMOVE_MULTIPLE = Translation.Type.GUI.wrap("mobeffect_removal_effect.remove_multiple");
    @Translation(comments={"Removes %s status effects"})
    public static final String REMOVE_ALL = Translation.Type.GUI.wrap("mobeffect_removal_effect.remove_all");
    @Translation(comments={" from:"})
    public static final String CATEGORY_FILTER = Translation.Type.GUI.wrap("mobeffect_removal_effect.category_filter");
    @Translation(comments={" limited to:"})
    public static final String LIMITED_TO = Translation.Type.GUI.wrap("mobeffect_removal_effect.limited_to");
    @Translation(comments={" with a level at most %s"})
    public static final String MAXIMUM_LEVEL = Translation.Type.GUI.wrap("mobeffect_removal_effect.maximum_level");
    public static final MapCodec<MobEffectRemovalEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list(MiscCodecs.enumCodec(MobEffectCategory.class)).optionalFieldOf("categories").forGetter(MobEffectRemovalEffect::categories), (App)RegistryCodecs.homogeneousList((ResourceKey)BuiltInRegistries.MOB_EFFECT.key()).optionalFieldOf("valid_effects").forGetter(MobEffectRemovalEffect::validEffects), (App)LevelBasedValue.CODEC.optionalFieldOf("max_amount").forGetter(MobEffectRemovalEffect::maxAmount), (App)LevelBasedValue.CODEC.optionalFieldOf("maximum_effect_level").forGetter(MobEffectRemovalEffect::maximumEffectLevel)).apply((Applicative)instance, MobEffectRemovalEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            ArrayList<Holder> effectsToRemove = new ArrayList<Holder>();
            for (MobEffectInstance instance : livingEntity.getActiveEffects()) {
                if (this.maxAmount.isPresent() && (float)effectsToRemove.size() >= this.maxAmount.get().calculate(ability.level())) break;
                if (!this.categories.isEmpty() && !this.categories.get().contains(((MobEffect)instance.getEffect().value()).getCategory()) || !this.validEffects.isEmpty() && !this.validEffects.get().contains(instance.getEffect()) || !this.maximumEffectLevel.isEmpty() && !((float)instance.getAmplifier() <= this.maximumEffectLevel.get().calculate(ability.level()))) continue;
                effectsToRemove.add(instance.getEffect());
            }
            effectsToRemove.forEach(arg_0 -> ((LivingEntity)livingEntity).removeEffect(arg_0));
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        List<MutableComponent> description = List.of(Component.empty());
        if (this.maxAmount.isPresent() && this.maxAmount.get().calculate(ability.level()) == 1.0f) {
            description.getFirst().append((Component)Component.translatable((String)REMOVE_ONE, (Object[])new Object[]{DSColors.dynamicValue("1")}));
        } else if (this.maxAmount.isPresent()) {
            description.getFirst().append((Component)Component.translatable((String)REMOVE_MULTIPLE, (Object[])new Object[]{DSColors.dynamicValue(Float.valueOf(this.maxAmount.get().calculate(ability.level())))}));
        } else {
            description.getFirst().append((Component)Component.translatable((String)REMOVE_ALL));
        }
        if (this.categories.isPresent()) {
            description.getFirst().append((Component)Component.translatable((String)CATEGORY_FILTER));
            for (MobEffectCategory category : this.categories.get()) {
                description.getFirst().append((Component)DSColors.withColor(Component.literal((String)(" " + category.name())), 0xFFAA00));
            }
        }
        if (this.validEffects.isPresent()) {
            description.getFirst().append((Component)Component.translatable((String)LIMITED_TO));
            for (Holder effect : this.validEffects.get()) {
                description.getFirst().append((Component)DSColors.withColor(Component.translatable((String)(" " + String.valueOf(((MobEffect)effect.value()).getDisplayName()))), 5736495));
            }
        }
        if (this.maximumEffectLevel.isPresent()) {
            description.getFirst().append((Component)Component.translatable((String)MAXIMUM_LEVEL, (Object[])new Object[]{DSColors.dynamicValue(this.maximumEffectLevel.get())}));
        }
        description.getFirst().append(".");
        return description;
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

