/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.Glow;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public record GlowEffect(List<Glow> glows) implements AbilityEntityEffect
{
    public static final MapCodec<GlowEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Glow.CODEC.listOf().fieldOf("glows").forGetter(GlowEffect::glows)).apply((Applicative)instance, GlowEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        this.glows.forEach(glow -> glow.apply(dragon, ability, target));
    }

    @Override
    public void remove(ServerPlayer dragon, DragonAbilityInstance ability, Entity entity, boolean isAutoRemoval) {
        this.glows.forEach(glow -> {
            if (!isAutoRemoval || glow.shouldRemoveAutomatically()) {
                glow.remove(entity);
            }
        });
    }

    public static List<GlowEffect> only(Glow modifier) {
        return List.of(new GlowEffect(List.of(modifier)));
    }

    public static GlowEffect single(Glow modifier) {
        return new GlowEffect(List.of(modifier));
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

