/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects.AbilityBlockEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public record UseItemOnBlockEffect(ItemStack item, LevelBasedValue probability, Optional<Holder<SoundEvent>> sound, Optional<BlockPredicate> validBlocks) implements AbilityBlockEffect
{
    public static final MapCodec<UseItemOnBlockEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(UseItemOnBlockEffect::item), (App)LevelBasedValue.CODEC.fieldOf("probability").forGetter(UseItemOnBlockEffect::probability), (App)SoundEvent.CODEC.optionalFieldOf("sound").forGetter(UseItemOnBlockEffect::sound), (App)BlockPredicate.CODEC.optionalFieldOf("valid_blocks").forGetter(UseItemOnBlockEffect::validBlocks)).apply((Applicative)instance, UseItemOnBlockEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, BlockPos position, @Nullable Direction direction) {
        ItemStack newStack;
        InteractionResult ir;
        if (dragon.getRandom().nextDouble() > (double)this.probability().calculate(ability.level())) {
            return;
        }
        ServerLevel level = dragon.serverLevel();
        if ((this.validBlocks.isEmpty() || this.validBlocks.get().test((Object)dragon.serverLevel(), (Object)position)) && (ir = (newStack = new ItemStack((ItemLike)this.item.getItem())).useOn(new UseOnContext((Level)level, (Player)dragon, InteractionHand.MAIN_HAND, newStack, new BlockHitResult(dragon.position(), direction, position, false)))).consumesAction()) {
            this.sound.ifPresent(soundHolder -> dragon.level().playSound(null, position, (SoundEvent)soundHolder.value(), SoundSource.BLOCKS, 1.0f, 1.0f));
        }
    }

    @Override
    public MapCodec<? extends AbilityBlockEffect> blockCodec() {
        return CODEC;
    }
}

