/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects.AbilityBlockEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public record FireEffect(LevelBasedValue igniteProbability) implements AbilityBlockEffect
{
    public static final MapCodec<FireEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("ignite_probability").forGetter(FireEffect::igniteProbability)).apply((Applicative)instance, FireEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, BlockPos position, Direction direction) {
        BlockState state = dragon.serverLevel().getBlockState(position);
        Block block = state.getBlock();
        if (block instanceof TntBlock) {
            TntBlock tnt = (TntBlock)block;
            tnt.onCaughtFire(state, dragon.level(), position, direction, (LivingEntity)dragon);
            dragon.level().setBlock(position, Blocks.AIR.defaultBlockState(), 11);
        } else if (block instanceof CampfireBlock && !((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
            dragon.level().setBlock(position, (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(true)), 11);
        } else if (state.getOptionalValue((Property)BlockStateProperties.SNOWY).orElse(false).booleanValue()) {
            dragon.level().setBlock(position, (BlockState)state.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(false)), 11);
        } else if (FireBlock.canBePlacedAt((Level)dragon.level(), (BlockPos)position, (Direction)direction) && dragon.getRandom().nextDouble() < (double)this.igniteProbability.calculate(ability.level())) {
            BlockState fireBlockState = FireBlock.getState((BlockGetter)dragon.level(), (BlockPos)position);
            dragon.level().setBlock(position, fireBlockState, 11);
            state.onCaughtFire(dragon.level(), position, direction, (LivingEntity)dragon);
        }
    }

    @Override
    public MapCodec<? extends AbilityBlockEffect> blockCodec() {
        return CODEC;
    }
}

