/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects.AbilityBlockEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import org.jetbrains.annotations.Nullable;

public record BlockHarvestEffect(BlockPredicate validBlocks, LevelBasedValue probability, Optional<ItemStack> tool) implements AbilityBlockEffect
{
    public static final MapCodec<BlockHarvestEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPredicate.CODEC.fieldOf("valid_blocks").forGetter(BlockHarvestEffect::validBlocks), (App)LevelBasedValue.CODEC.fieldOf("probability").forGetter(BlockHarvestEffect::probability), (App)ItemStack.CODEC.optionalFieldOf("tool").forGetter(BlockHarvestEffect::tool)).apply((Applicative)instance, BlockHarvestEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, BlockPos position, @Nullable Direction direction) {
        if ((double)this.probability.calculate(ability.level()) < dragon.getRandom().nextDouble()) {
            return;
        }
        ServerLevel level = dragon.serverLevel();
        if (this.validBlocks.test((Object)level, (Object)position)) {
            ItemStack blockTool = this.tool.orElse(ItemStack.EMPTY);
            BlockState blockState = level.getBlockState(position);
            BlockEntity blockEntity = blockState.hasBlockEntity() ? level.getBlockEntity(position) : null;
            Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)position, (BlockEntity)blockEntity, (Entity)dragon, (ItemStack)blockTool);
        }
    }

    @Override
    public MapCodec<? extends AbilityBlockEffect> blockCodec() {
        return CODEC;
    }
}

