/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.PotionData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects.AbilityBlockEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import org.jetbrains.annotations.Nullable;

public record AreaCloudEffect(PotionData potion, LevelBasedValue duration, LevelBasedValue probability, Optional<LevelBasedValue> delay, Optional<LevelBasedValue> radius, ParticleOptions particle) implements AbilityBlockEffect
{
    public static final MapCodec<AreaCloudEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PotionData.CODEC.fieldOf("potion").forGetter(AreaCloudEffect::potion), (App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(AreaCloudEffect::duration), (App)LevelBasedValue.CODEC.fieldOf("probability").forGetter(AreaCloudEffect::probability), (App)LevelBasedValue.CODEC.optionalFieldOf("delay").forGetter(AreaCloudEffect::delay), (App)LevelBasedValue.CODEC.optionalFieldOf("radius").forGetter(AreaCloudEffect::radius), (App)ParticleTypes.CODEC.fieldOf("particle").forGetter(AreaCloudEffect::particle)).apply((Applicative)instance, AreaCloudEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, BlockPos position, @Nullable Direction direction) {
        if (dragon.level().random.nextDouble() < (double)this.probability.calculate(ability.level()) && dragon.level().getBlockState(position).isSolid()) {
            AreaEffectCloud cloud = new AreaEffectCloud(dragon.level(), (double)position.above().getX(), (double)position.above().getY(), (double)position.above().getZ());
            cloud.setPotionContents(this.potion.toPotionContents(dragon.getRandom(), ability.level()));
            cloud.setDuration((int)this.duration.calculate(ability.level()));
            cloud.setParticle(this.particle);
            cloud.setOwner((LivingEntity)dragon);
            cloud.setWaitTime((int)this.delay.orElse((LevelBasedValue)LevelBasedValue.constant((float)0.0f)).calculate(ability.level()));
            cloud.setRadius((float)((int)this.radius.orElse((LevelBasedValue)LevelBasedValue.constant((float)1.0f)).calculate(ability.level())));
            dragon.level().addFreshEntity((Entity)cloud);
        }
    }

    @Override
    public MapCodec<? extends AbilityBlockEffect> blockCodec() {
        return CODEC;
    }
}

