/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ManaHandling;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscResources;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ModifierType;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.UnlockableBehavior;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.AttributeModifierSupplier;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.BuiltInDragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.ItemBlacklistPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DragonSpecies
implements AttributeModifierSupplier {
    public static final ResourceKey<Registry<DragonSpecies>> REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)DragonSurvival.res("dragon_species"));
    public static final Codec<DragonSpecies> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MiscCodecs.doubleRange(1.0, Double.MAX_VALUE).optionalFieldOf("starting_growth").forGetter(DragonSpecies::startingGrowth), (App)UnlockableBehavior.CODEC.optionalFieldOf("unlockable_behavior").forGetter(DragonSpecies::unlockableBehavior), (App)ManaHandling.CODEC.optionalFieldOf("mana_handling", (Object)ManaHandling.DEFAULT).forGetter(DragonSpecies::manaHandling), (App)RegistryCodecs.homogeneousList(DragonStage.REGISTRY).optionalFieldOf("custom_stage_progression").forGetter(DragonSpecies::stages), (App)RegistryCodecs.homogeneousList(DragonBody.REGISTRY).optionalFieldOf("bodies", (Object)HolderSet.empty()).forGetter(DragonSpecies::bodies), (App)RegistryCodecs.homogeneousList(DragonAbility.REGISTRY).optionalFieldOf("abilities", (Object)HolderSet.empty()).forGetter(DragonSpecies::abilities), (App)RegistryCodecs.homogeneousList(DragonPenalty.REGISTRY).optionalFieldOf("penalties", (Object)HolderSet.empty()).forGetter(DragonSpecies::penalties), (App)MiscResources.CODEC.fieldOf("misc_resources").forGetter(DragonSpecies::miscResources)).apply((Applicative)instance, instance.stable(DragonSpecies::new)));
    public static final Codec<Holder<DragonSpecies>> CODEC = RegistryFixedCodec.create(REGISTRY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DragonSpecies>> STREAM_CODEC = ByteBufCodecs.holderRegistry(REGISTRY);
    private final Optional<Double> startingGrowth;
    private final Optional<UnlockableBehavior> unlockableBehavior;
    private final ManaHandling manaHandling;
    private final Optional<HolderSet<DragonStage>> customStageProgression;
    private final HolderSet<DragonBody> bodies;
    private final HolderSet<DragonAbility> abilities;
    private final HolderSet<DragonPenalty> penalties;
    private final MiscResources miscResources;

    public DragonSpecies(Optional<Double> startingGrowth, Optional<UnlockableBehavior> unlockableBehavior, ManaHandling manaHandling, Optional<HolderSet<DragonStage>> customStageProgression, HolderSet<DragonBody> bodies, HolderSet<DragonAbility> abilities, HolderSet<DragonPenalty> penalties, MiscResources miscResources) {
        this.startingGrowth = startingGrowth;
        this.unlockableBehavior = unlockableBehavior;
        this.manaHandling = manaHandling;
        this.customStageProgression = customStageProgression;
        this.bodies = bodies;
        this.abilities = abilities;
        this.penalties = penalties;
        this.miscResources = miscResources;
    }

    public static void validate(@Nullable HolderLookup.Provider provider) {
        StringBuilder validationError = new StringBuilder("The following types are incorrectly defined:");
        AtomicBoolean areTypesValid = new AtomicBoolean(true);
        ResourceHelper.keys(provider, REGISTRY).forEach(key -> {
            Holder.Reference type = ResourceHelper.get(provider, key).get();
            if (((DragonSpecies)type.value()).stages().isPresent() && !DragonStage.areStagesConnected(((DragonSpecies)type.value()).stages().get(), validationError, false)) {
                areTypesValid.set(false);
            }
        });
        if (!areTypesValid.get()) {
            throw new IllegalStateException(validationError.toString());
        }
    }

    @SubscribeEvent
    public static void register(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(REGISTRY, DIRECT_CODEC, DIRECT_CODEC);
    }

    public static List<UnlockableBehavior.SpeciesEntry> getSpecies(ServerPlayer player, boolean isAltar) {
        ArrayList<UnlockableBehavior.SpeciesEntry> entries = new ArrayList<UnlockableBehavior.SpeciesEntry>();
        ResourceHelper.all((HolderLookup.Provider)player.registryAccess(), REGISTRY).forEach(species -> {
            UnlockableBehavior behaviour = ((DragonSpecies)species.value()).unlockableBehavior().orElse(null);
            if (behaviour == null) {
                entries.add(new UnlockableBehavior.SpeciesEntry((Holder<DragonSpecies>)species, true));
                return;
            }
            boolean isUnlocked = behaviour.unlockCondition().map(condition -> condition.test((Object)Condition.entityContext(player.serverLevel(), (Entity)player))).orElse(true);
            UnlockableBehavior.Visibility visibility = behaviour.visibility().orElse(null);
            if (isAltar) {
                if (visibility == UnlockableBehavior.Visibility.ALWAYS_VISIBLE) {
                    entries.add(new UnlockableBehavior.SpeciesEntry((Holder<DragonSpecies>)species, isUnlocked));
                    return;
                }
                if (visibility == UnlockableBehavior.Visibility.ALWAYS_HIDDEN) {
                    return;
                }
            }
            if (isUnlocked) {
                entries.add(new UnlockableBehavior.SpeciesEntry((Holder<DragonSpecies>)species, true));
                return;
            }
            if (isAltar && visibility == UnlockableBehavior.Visibility.VISIBLE_IF_LOCKED) {
                entries.add(new UnlockableBehavior.SpeciesEntry((Holder<DragonSpecies>)species, false));
            }
        });
        return entries;
    }

    @Nullable
    public static Holder<DragonSpecies> getRandom(ServerPlayer player) {
        List<UnlockableBehavior.SpeciesEntry> unlockedSpecies = DragonSpecies.getSpecies(player, false);
        if (unlockedSpecies.isEmpty()) {
            return null;
        }
        return unlockedSpecies.get(player.getRandom().nextInt(unlockedSpecies.size())).species();
    }

    public boolean isItemBlacklisted(Item item) {
        for (Holder penalty : this.penalties) {
            ItemBlacklistPenalty blacklist;
            PenaltyEffect penaltyEffect = ((DragonPenalty)penalty.value()).effect();
            if (!(penaltyEffect instanceof ItemBlacklistPenalty) || !(blacklist = (ItemBlacklistPenalty)penaltyEffect).isBlacklisted(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModifierType getModifierType() {
        return ModifierType.DRAGON_TYPE;
    }

    public double getStartingGrowth(@Nullable HolderLookup.Provider provider) {
        return this.startingGrowth.orElseGet(() -> DragonStage.getStartingGrowth(this.getStages(provider)));
    }

    public Holder<DragonStage> getStartingStage(@Nullable HolderLookup.Provider provider) {
        return DragonStage.get(this.getStages(provider), this.getStartingGrowth(provider));
    }

    public HolderSet<DragonStage> getStages(@Nullable HolderLookup.Provider provider) {
        return this.customStageProgression.orElseGet(() -> DragonStage.getDefaultStages(provider));
    }

    public Optional<Double> startingGrowth() {
        return this.startingGrowth;
    }

    public Optional<UnlockableBehavior> unlockableBehavior() {
        return this.unlockableBehavior;
    }

    public ManaHandling manaHandling() {
        return this.manaHandling;
    }

    public Optional<HolderSet<DragonStage>> stages() {
        return this.customStageProgression;
    }

    public HolderSet<DragonBody> bodies() {
        return this.bodies;
    }

    public HolderSet<DragonAbility> abilities() {
        return this.abilities;
    }

    public MiscResources miscResources() {
        return this.miscResources;
    }

    public HolderSet<DragonPenalty> penalties() {
        return this.penalties;
    }

    public boolean isValidForBody(Holder<DragonBody> body) {
        return this.bodies.size() == 0 && ((DragonBody)body.value()).model().equals((Object)DragonBody.DEFAULT_MODEL) || this.bodies.contains(body);
    }

    public static boolean isBuiltIn(ResourceKey<DragonSpecies> speciesKey) {
        return speciesKey.equals(BuiltInDragonSpecies.CAVE_DRAGON) || speciesKey.equals(BuiltInDragonSpecies.FOREST_DRAGON) || speciesKey.equals(BuiltInDragonSpecies.SEA_DRAGON);
    }
}

