/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBodies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DSDragonBodyTags
extends TagsProvider<DragonBody> {
    public static final TagKey<DragonBody> ORDER = DSDragonBodyTags.key("order");

    public DSDragonBodyTags(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper helper) {
        super(output, DragonBody.REGISTRY, provider, "dragonsurvival", helper);
    }

    protected void addTags(@NotNull HolderLookup.Provider provider) {
        this.tag(ORDER).add(new ResourceKey[]{DragonBodies.CENTER, DragonBodies.EAST, DragonBodies.NORTH, DragonBodies.SOUTH, DragonBodies.WEST});
    }

    public static List<Holder<DragonBody>> getOrdered(@Nullable HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup registry = provider != null ? provider.lookupOrThrow(DragonBody.REGISTRY) : CommonHooks.resolveLookup(DragonBody.REGISTRY);
        ArrayList<Holder<DragonBody>> bodies = new ArrayList<Holder<DragonBody>>();
        registry.get(ORDER).ifPresent(set -> set.forEach(bodies::add));
        registry.listElements().forEach(body -> {
            if (!bodies.contains(body)) {
                bodies.add((Holder<DragonBody>)body);
            }
        });
        return bodies;
    }

    private static TagKey<DragonBody> key(String path) {
        return TagKey.create(DragonBody.REGISTRY, (ResourceLocation)DragonSurvival.res(path));
    }
}

