/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonAltarBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.ModCompat;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.SkeletonPieceBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.TreasureBlock;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DSBlockTags
extends BlockTagsProvider {
    @Translation(comments={"Enables Hunter Effect"})
    public static final TagKey<Block> ENABLES_HUNTER_EFFECT = DSBlockTags.key("enables_hunter_effect");
    @Translation(comments={"Destructible by Large Dragons"})
    public static final TagKey<Block> LARGE_DRAGON_DESTRUCTIBLE = DSBlockTags.key("large_dragon_destructible");
    @Translation(comments={"Not replaced by the dragon end platform"})
    public static final TagKey<Block> END_PLATFORM_NON_REPLACEABLE = DSBlockTags.key("end_platform_non_replaceable");
    @Translation(comments={"Speeds up Cave Dragons"})
    public static final TagKey<Block> SPEEDS_UP_CAVE_DRAGON = DSBlockTags.key("speeds_up_cave_dragon");
    @Translation(comments={"Speeds up Sea Dragons"})
    public static final TagKey<Block> SPEEDS_UP_SEA_DRAGON = DSBlockTags.key("speeds_up_sea_dragon");
    @Translation(comments={"Speeds up Forest Dragons"})
    public static final TagKey<Block> SPEEDS_UP_FOREST_DRAGON = DSBlockTags.key("speeds_up_forest_dragon");
    @Translation(comments={"Is Warm"})
    public static final TagKey<Block> IS_WARM = DSBlockTags.key("warm_blocks");
    @Translation(comments={"Is Grassy"})
    public static final TagKey<Block> IS_GRASSY = DSBlockTags.key("is_grassy");
    @Translation(comments={"Is Wet"})
    public static final TagKey<Block> IS_WET = DSBlockTags.key("is_wet");
    @Translation(comments={"General Ores"})
    public static final TagKey<Block> GENERAL_ORES = DSBlockTags.key("general_ores");
    @Translation(comments={"Dragon Altars"})
    public static final TagKey<Block> DRAGON_ALTARS = DSBlockTags.key("dragon_altars");
    @Translation(comments={"Dragon Treasures"})
    public static final TagKey<Block> DRAGON_TREASURES = DSBlockTags.key("dragon_treasures");
    @Translation(comments={"Wooden Dragon Doors"})
    public static final TagKey<Block> WOODEN_DRAGON_DOORS = DSBlockTags.key("wooden_dragon_doors");
    @Translation(comments={"Small Wooden Dragon Doors"})
    public static final TagKey<Block> SMALL_WOODEN_DRAGON_DOORS = DSBlockTags.key("small_wooden_dragon_doors");
    @Translation(comments={"Dragon Dust/Bone Dropping Blocks"})
    public static final TagKey<Block> DRAGON_ORE_DROP = DSBlockTags.key("dragon_ore_drop");

    public DSBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "dragonsurvival", existingFileHelper);
    }

    protected void addTags(@NotNull HolderLookup.Provider provider) {
        this.addToVanillaTags();
        this.addToDragonSpeedUpTags();
        this.addToTypeTags();
        DSBlocks.REGISTRY.getEntries().forEach(holder -> {
            Block block;
            Block block2 = block = (Block)holder.value();
            Objects.requireNonNull(block2);
            Block selector0$temp = block2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DragonAltarBlock.class, TreasureBlock.class, SkeletonPieceBlock.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    DragonAltarBlock ignored = (DragonAltarBlock)selector0$temp;
                    this.tag(DRAGON_ALTARS).add((Object)block);
                    break;
                }
                case 1: {
                    ModCompat compat;
                    TreasureBlock ignored = (TreasureBlock)selector0$temp;
                    Object patt2$temp = holder.get();
                    if (patt2$temp instanceof ModCompat && (compat = (ModCompat)patt2$temp).getCompatId() != null) {
                        this.tag(DRAGON_TREASURES).addOptional(holder.getId());
                        break;
                    }
                    this.tag(DRAGON_TREASURES).add((Object)block);
                    break;
                }
                case 2: {
                    SkeletonPieceBlock ignored = (SkeletonPieceBlock)selector0$temp;
                    this.tag(DSBlockTags.key("dragon_bones")).add((Object)block);
                    break;
                }
            }
        });
        this.tag(LARGE_DRAGON_DESTRUCTIBLE).addTag(BlockTags.LEAVES).addTag(BlockTags.MINEABLE_WITH_AXE).addTag(BlockTags.FLOWERS).addTag(BlockTags.REPLACEABLE);
        this.tag(END_PLATFORM_NON_REPLACEABLE).add((Object)Blocks.SNOW);
        this.tag(SMALL_WOODEN_DRAGON_DOORS).add((Object)((Block)DSBlocks.SMALL_OAK_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_SPRUCE_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_ACACIA_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_BIRCH_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_JUNGLE_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_DARK_OAK_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_WARPED_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_CRIMSON_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_FOREST_DRAGON_DOOR.value()));
        this.tag(WOODEN_DRAGON_DOORS).add((Object)((Block)DSBlocks.OAK_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SPRUCE_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.ACACIA_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.BIRCH_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.JUNGLE_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.DARK_OAK_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.WARPED_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.CRIMSON_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.FOREST_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.LEGACY_DRAGON_DOOR.value()));
        this.tag(ENABLES_HUNTER_EFFECT).addTag(BlockTags.FLOWERS).addTag(BlockTags.SAPLINGS).add((Object)Blocks.WARPED_NYLIUM).add((Object)Blocks.CRIMSON_NYLIUM).add((Object)Blocks.GRASS_BLOCK).add((Object)Blocks.FERN).add((Object)Blocks.LARGE_FERN).add((Object)Blocks.DEAD_BUSH).add((Object)Blocks.SWEET_BERRY_BUSH).add((Object)Blocks.TALL_GRASS).add((Object)Blocks.GLOW_LICHEN).add((Object)Blocks.CRIMSON_ROOTS).add((Object)Blocks.WARPED_ROOTS).add((Object)Blocks.NETHER_SPROUTS).add((Object)Blocks.BIG_DRIPLEAF).add((Object)Blocks.SMALL_DRIPLEAF);
        this.tag(DRAGON_ORE_DROP).addTag(Tags.Blocks.ORES_QUARTZ).addTag(Tags.Blocks.ORES_COAL).addTag(Tags.Blocks.ORES_REDSTONE).addTag(Tags.Blocks.ORES_LAPIS).add((Object)Blocks.NETHER_GOLD_ORE).addTag(Tags.Blocks.ORES_DIAMOND).addTag(Tags.Blocks.ORES_EMERALD);
        this.tag(GENERAL_ORES).addTag(Tags.Blocks.ORES).add((Object)Blocks.GILDED_BLACKSTONE).remove(Tags.Blocks.ORES_QUARTZ).remove(Tags.Blocks.ORES_NETHERITE_SCRAP).remove(Tags.Blocks.ORES_COAL).remove(Tags.Blocks.ORES_COPPER).remove(Tags.Blocks.ORES_IRON).remove(Tags.Blocks.ORES_GOLD).remove(Tags.Blocks.ORES_REDSTONE).remove(Tags.Blocks.ORES_LAPIS).remove(Tags.Blocks.ORES_EMERALD).remove(Tags.Blocks.ORES_DIAMOND);
    }

    private void addToTypeTags() {
        this.tag(IS_WARM).addTag(BlockTags.FIRE).add((Object)Blocks.MAGMA_BLOCK).add((Object)((Block)DSBlocks.CAVE_SOURCE_OF_MAGIC.value())).addOptionalTag(DragonSurvival.location("immersive_weathering", "charred_blocks")).addOptionalTag(DragonSurvival.location("regions_unexplored", "ash")).addOptional(DragonSurvival.location("netherdepthsupgrade", "wet_lava_sponge")).addOptional(DragonSurvival.location("regions_unexplored", "brimwood_log_magma"));
        this.tag(IS_GRASSY).addTag(BlockTags.FLOWERS).addTag(BlockTags.LEAVES).add((Object)Blocks.BROWN_MUSHROOM_BLOCK).add((Object)Blocks.RED_MUSHROOM_BLOCK).add((Object)Blocks.SWEET_BERRY_BUSH).add((Object)Blocks.BROWN_MUSHROOM).add((Object)Blocks.RED_MUSHROOM).add((Object)Blocks.MOSS_CARPET).add((Object)Blocks.GRASS_BLOCK).add((Object)Blocks.MOSS_BLOCK).add((Object)Blocks.MYCELIUM).add((Object)Blocks.LILY_PAD).add((Object)((Block)DSBlocks.FOREST_SOURCE_OF_MAGIC.value())).addOptional(DragonSurvival.location("regions_unexplored", "spanish_moss")).addOptional(DragonSurvival.location("regions_unexplored", "mycotoxic_mushrooms")).addOptional(DragonSurvival.location("regions_unexplored", "alpha_grass_block")).addOptional(DragonSurvival.location("regions_unexplored", "chalk_grass_block")).addOptional(DragonSurvival.location("regions_unexplored", "peat_grass_block")).addOptional(DragonSurvival.location("regions_unexplored", "silt_grass_block")).addOptional(DragonSurvival.location("regions_unexplored", "argillite_grass_block")).addOptional(DragonSurvival.location("regions_unexplored", "stone_grass_block")).addOptional(DragonSurvival.location("regions_unexplored", "deepslate_grass_block")).addOptional(DragonSurvival.location("regions_unexplored", "rooted_grass_block")).addOptional(DragonSurvival.location("phantasm", "vivid_nihilium_grass")).addOptional(DragonSurvival.location("vinery", "grass_slab"));
        this.tag(IS_WET).addTag(BlockTags.SNOW).addTag(BlockTags.ICE).add((Object)Blocks.WATER_CAULDRON).add((Object)Blocks.WET_SPONGE).add((Object)Blocks.MUDDY_MANGROVE_ROOTS).add((Object)Blocks.MUD).add((Object)((Block)DSBlocks.SEA_SOURCE_OF_MAGIC.value())).addOptional(DragonSurvival.location("immersive_weathering", "thin_ice")).addOptional(DragonSurvival.location("immersive_weathering", "cryosol")).addOptional(DragonSurvival.location("immersive_weathering", "permafrost")).addOptional(DragonSurvival.location("immersive_weathering", "frosty_grass")).addOptional(DragonSurvival.location("immersive_weathering", "frosty_fern")).addOptional(DragonSurvival.location("immersive_weathering", "icicle")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_stone")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_stone_slab")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_stone_wall")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_stone_stairs")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_stone_bricks")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_stone_brick_slab")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_stone_brick_wall")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_stone_brick_stairs")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_cobblestone")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_cobblestone_slab")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_cobblestone_wall")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_cobblestone_stairs")).addOptional(DragonSurvival.location("immersive_weathering", "snow_bricks")).addOptional(DragonSurvival.location("immersive_weathering", "snow_brick_slab")).addOptional(DragonSurvival.location("immersive_weathering", "snow_brick_wall")).addOptional(DragonSurvival.location("immersive_weathering", "snow_brick_stairs")).addOptional(DragonSurvival.location("immersive_weathering", "snowy_chiseled_stone_bricks")).addOptional(DragonSurvival.location("regions_unexplored", "plains_mud")).addOptional(DragonSurvival.location("regions_unexplored", "silt_mud")).addOptional(DragonSurvival.location("regions_unexplored", "peat_mud")).addOptional(DragonSurvival.location("regions_unexplored", "forest_mud"));
    }

    private void addToDragonSpeedUpTags() {
        this.tag(SPEEDS_UP_CAVE_DRAGON).addTag(BlockTags.BASE_STONE_OVERWORLD).add((Object)Blocks.NETHERITE_BLOCK).add((Object)Blocks.NETHER_BRICK_FENCE).add((Object)Blocks.NETHER_BRICKS).add((Object)Blocks.CRACKED_NETHER_BRICKS).add((Object)Blocks.NETHER_BRICK_SLAB).add((Object)Blocks.NETHER_BRICK_STAIRS).add((Object)Blocks.NETHER_BRICK_WALL).add((Object)Blocks.RED_NETHER_BRICKS).add((Object)Blocks.RED_NETHER_BRICK_SLAB).add((Object)Blocks.RED_NETHER_BRICK_STAIRS).add((Object)Blocks.RED_NETHER_BRICK_WALL).add((Object)Blocks.BLACKSTONE).add((Object)Blocks.BLACKSTONE_SLAB).add((Object)Blocks.BLACKSTONE_STAIRS).add((Object)Blocks.BLACKSTONE_WALL).add((Object)Blocks.GILDED_BLACKSTONE).add((Object)Blocks.CHISELED_POLISHED_BLACKSTONE).add((Object)Blocks.POLISHED_BLACKSTONE).add((Object)Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS).add((Object)Blocks.POLISHED_BLACKSTONE_BRICK_SLAB).add((Object)Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS).add((Object)Blocks.POLISHED_BLACKSTONE_BRICKS).add((Object)Blocks.POLISHED_BLACKSTONE_PRESSURE_PLATE).add((Object)Blocks.POLISHED_BLACKSTONE_BRICK_WALL).add((Object)Blocks.POLISHED_BLACKSTONE_BUTTON).addTag(BlockTags.BEACON_BASE_BLOCKS).addTag(BlockTags.BASE_STONE_NETHER).addTag(BlockTags.STONE_BRICKS).addTag(Tags.Blocks.SANDSTONE_BLOCKS).addTag(Tags.Blocks.COBBLESTONES).addTag(Tags.Blocks.STONES).addTag(Tags.Blocks.ORES).addTag(IS_WARM);
        this.tag(SPEEDS_UP_SEA_DRAGON).addTag(BlockTags.CORAL_BLOCKS).addTag(BlockTags.IMPERMEABLE).addTag(BlockTags.SAND).addTag(Tags.Blocks.SANDSTONE_BLOCKS).addTag(Tags.Blocks.SANDS).addTag(IS_WET).add((Object)Blocks.DIRT_PATH).add((Object)Blocks.SAND).add((Object)Blocks.CLAY).add((Object)Blocks.DRIPSTONE_BLOCK).add((Object)Blocks.PRISMARINE).add((Object)Blocks.PRISMARINE_SLAB).add((Object)Blocks.PRISMARINE_STAIRS).add((Object)Blocks.PRISMARINE_WALL).add((Object)Blocks.PRISMARINE_BRICKS).add((Object)Blocks.PRISMARINE_BRICK_SLAB).add((Object)Blocks.PRISMARINE_BRICK_STAIRS).add((Object)Blocks.DARK_PRISMARINE).add((Object)Blocks.DARK_PRISMARINE_SLAB).add((Object)Blocks.DARK_PRISMARINE_STAIRS).add((Object)Blocks.MUD);
        this.tag(SPEEDS_UP_FOREST_DRAGON).addTag(BlockTags.WOODEN_SLABS).addTag(BlockTags.PLANKS).addTag(BlockTags.LOGS).addTag(BlockTags.DIRT).addTag(IS_GRASSY).add((Object)Blocks.GRASS_BLOCK);
    }

    private void addToVanillaTags() {
        this.tag(BlockTags.MINEABLE_WITH_AXE).addTag(WOODEN_DRAGON_DOORS).add((Object)((Block)DSBlocks.OAK_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.BIRCH_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.PALE_OAK_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.CRIMSON_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.WARPED_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.MANGROVE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.BAMBOO_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.CHERRY_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.ACACIA_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.DARK_OAK_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.JUNGLE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.SPRUCE_DRAGON_ALTAR.value())).addTag(SMALL_WOODEN_DRAGON_DOORS).add((Object)((Block)DSBlocks.FOREST_DRAGON_PRESSURE_PLATE.value()));
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((Block)DSBlocks.STONE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.SANDSTONE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.RED_SANDSTONE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.PURPUR_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.NETHER_BRICK_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.MOSSY_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.BLACKSTONE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.BONE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.QUARTZ_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.ICE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.NETHERRACK_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.OBSIDIAN_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.AMETHYST_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.MUDBRICK_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.PRISMARINE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.RED_NETHER_BRICK_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.ENDSTONE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.DEEPSLATE_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.TUFF_DRAGON_ALTAR.value())).add((Object)((Block)DSBlocks.CAVE_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SEA_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.IRON_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_STONE_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_GOTHIC_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_CAVE_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_SEA_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_IRON_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_SKYRIM_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SKYRIM_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.GOTHIC_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.STONE_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.CAVE_SOURCE_OF_MAGIC.value())).add((Object)((Block)DSBlocks.FOREST_SOURCE_OF_MAGIC.value())).add((Object)((Block)DSBlocks.SEA_SOURCE_OF_MAGIC.value())).add((Object)((Block)DSBlocks.DEBRIS_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.DIAMOND_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.EMERALD_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.COPPER_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.GOLD_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.IRON_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.GRAY_KNIGHT_HELMET.value())).add((Object)((Block)DSBlocks.GOLDEN_KNIGHT_HELMET.value())).add((Object)((Block)DSBlocks.BLACK_KNIGHT_HELMET.value())).add((Object)((Block)DSBlocks.DRAGON_BEACON.value())).add((Object)((Block)DSBlocks.DRAGON_MEMORY_BLOCK.value())).add((Object)((Block)DSBlocks.DRAGON_PRESSURE_PLATE.value())).add((Object)((Block)DSBlocks.HUMAN_PRESSURE_PLATE.value())).add((Object)((Block)DSBlocks.SEA_DRAGON_PRESSURE_PLATE.value())).add((Object)((Block)DSBlocks.CAVE_DRAGON_PRESSURE_PLATE.value()));
        this.tag(BlockTags.NEEDS_STONE_TOOL).add((Object)((Block)DSBlocks.GOLD_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.EMERALD_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.DIAMOND_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.DEBRIS_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.IRON_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_IRON_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SKYRIM_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.SMALL_SKYRIM_DRAGON_DOOR.value())).add((Object)((Block)DSBlocks.COPPER_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.IRON_DRAGON_TREASURE.value())).add((Object)((Block)DSBlocks.GRAY_KNIGHT_HELMET.value())).add((Object)((Block)DSBlocks.GOLDEN_KNIGHT_HELMET.value())).add((Object)((Block)DSBlocks.BLACK_KNIGHT_HELMET.value()));
        this.tag(BlockTags.NEEDS_IRON_TOOL).add((Object)((Block)DSBlocks.DRAGON_BEACON.value())).add((Object)((Block)DSBlocks.DRAGON_MEMORY_BLOCK.value()));
    }

    private static TagKey<Block> key(@NotNull String name) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)name));
    }

    @NotNull
    public String getName() {
        return "Dragon Survival Block tags";
    }
}

