/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen.advancements;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.predicates.DragonPredicate;
import by.dragonsurvivalteam.dragonsurvival.common.conditions.EntityCondition;
import by.dragonsurvivalteam.dragonsurvival.common.criteria.BeDragonTrigger;
import by.dragonsurvivalteam.dragonsurvival.common.criteria.ConvertItemFromAbility;
import by.dragonsurvivalteam.dragonsurvival.common.criteria.MineBlockUnderLavaTrigger;
import by.dragonsurvivalteam.dragonsurvival.common.criteria.SleepOnTreasureTrigger;
import by.dragonsurvivalteam.dragonsurvival.common.criteria.StealFromVillagerTrigger;
import by.dragonsurvivalteam.dragonsurvival.common.criteria.StopNaturalGrowthTrigger;
import by.dragonsurvivalteam.dragonsurvival.common.criteria.UpgradeAbilityTrigger;
import by.dragonsurvivalteam.dragonsurvival.common.criteria.UseDragonSoulTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAdvancementTriggers;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEnchantments;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.abilities.CaveDragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.abilities.ForestDragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.abilities.SeaDragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.advancements.Builder;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSItemTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.BuiltInDragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStages;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.authlib.properties.PropertyMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.RecipeCraftedTrigger;
import net.minecraft.advancements.critereon.ShotCrossbowTrigger;
import net.minecraft.advancements.critereon.UsingItemTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DSAdvancements
implements AdvancementProvider.AdvancementGenerator {
    private HolderLookup.Provider registries;
    private Consumer<AdvancementHolder> saver;
    private ExistingFileHelper helper;

    public void generate(@NotNull HolderLookup.Provider registries, @NotNull Consumer<AdvancementHolder> saver, @NotNull ExistingFileHelper helper) {
        this.registries = registries;
        this.saver = saver;
        this.helper = helper;
        AdvancementHolder root = this.create("root").type(AdvancementType.GOAL).displayItem((ItemLike)DSItems.ELDER_DRAGON_BONE.value()).background(DragonSurvival.res("textures/block/stone_dragon_door_top.png")).noDescription().criteria("root", PlayerTrigger.TriggerInstance.tick()).build(saver, helper);
        AdvancementHolder beDragon = this.create("be_dragon").parent(root).displayItem((ItemLike)DSItems.STAR_BONE.value()).criteria("be_dragon", this.beDragon()).experienceReward(12).build(saver, helper);
        this.buildBeDragonChildren(beDragon);
        AdvancementHolder collectDust = this.create("collect_dust").parent(root).displayItem((ItemLike)Items.COAL_ORE).criteria("collect_elder_dragon_dust", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.ELDER_DRAGON_DUST.value()})).experienceReward(6).build(saver, helper);
        this.buildCollectDustChildren(collectDust);
        AdvancementHolder placeAltar = this.create("place_altar").parent(root).displayItem((ItemLike)DSBlocks.STONE_DRAGON_ALTAR.value()).criteria("place_dragon_altar", this.placeBlock(DSItemTags.DRAGON_ALTARS)).experienceReward(6).build(saver, helper);
        this.buildPlaceAltarChildren(placeAltar);
        AdvancementHolder pathChoice = this.create("path_choice").parent(root).displayItem((ItemLike)Items.OAK_SIGN).criteria("interact_with_villager", this.noItemInteract(EntityType.VILLAGER)).experienceReward(6).build(saver, helper);
        this.buildHunterAdvancements(pathChoice);
        this.buildLightAdvancements(pathChoice);
        this.buildDarkAdvancements(pathChoice);
    }

    private void buildDarkAdvancements(AdvancementHolder parent) {
        ItemStack head = Items.PLAYER_HEAD.getDefaultInstance();
        head.set(DataComponents.PROFILE, (Object)new ResolvableProfile(Optional.of("MHF_Villager"), Optional.empty(), new PropertyMap()));
        AdvancementHolder affectedByHunterOmen = this.create("dark/affected_by_hunter_omen").parent(parent).displayItem(head).showToast().announceChat().criteria("affected_by_hunter_omen", this.effectWithMinDuration(DSEffects.HUNTER_OMEN, 300)).experienceReward(6).build(this.saver, this.helper);
        this.create("dark/steal_from_villager").parent(affectedByHunterOmen).displayItem((ItemLike)DSItems.PARTISAN.value()).showToast().announceChat().criteria("steal_from_villager", this.stealFromVillager()).build(this.saver, this.helper);
        AdvancementHolder collectKey = this.create("dark/collect_key").parent(affectedByHunterOmen).displayItem((ItemLike)DSItems.DARK_KEY.value()).showToast().announceChat().criteria("collect_dark_key", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.DARK_KEY.value()})).build(this.saver, this.helper);
        AdvancementHolder openVault = this.create("dark/open_vault").parent(collectKey).displayItem((ItemLike)DSBlocks.DARK_VAULT.value()).showToast().announceChat().criteria("open_dark_vault", this.itemUsedOnBlock((Block)DSBlocks.DARK_VAULT.value(), (ItemLike)DSItems.DARK_KEY.value())).experienceReward(10).build(this.saver, this.helper);
        AdvancementHolder getArmorItem = this.create("dark/get_armor_item").parent(openVault).displayItem((ItemLike)DSItems.DARK_DRAGON_HELMET.value()).showToast().announceChat().criteria("collect_dark_armor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.DARK_DRAGON_HELMET.value(), (ItemLike)DSItems.DARK_DRAGON_CHESTPLATE.value(), (ItemLike)DSItems.DARK_DRAGON_LEGGINGS.value(), (ItemLike)DSItems.DARK_DRAGON_BOOTS.value()})).build(this.saver, this.helper);
        this.create("dark/get_armor_set").parent(getArmorItem).displayItem((ItemLike)DSItems.DARK_DRAGON_HELMET.value()).showToast().announceChat().criteria("collect_dark_armor_helmet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.DARK_DRAGON_HELMET.value()})).criteria("collect_dark_armor_chestplate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.DARK_DRAGON_CHESTPLATE.value()})).criteria("collect_dark_armor_leggings", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.DARK_DRAGON_LEGGINGS.value()})).criteria("collect_dark_armor_boots", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.DARK_DRAGON_BOOTS.value()})).build(this.saver, this.helper);
    }

    private void buildLightAdvancements(AdvancementHolder parent) {
        AdvancementHolder dragonRiderWorkbench = this.create("light/dragon_rider_workbench").parent(parent).displayItem((ItemLike)DSBlocks.DRAGON_RIDER_WORKBENCH.value()).criteria("craft_dragon_rider_workbench", this.crafted((ItemLike)DSBlocks.DRAGON_RIDER_WORKBENCH.value())).experienceReward(6).build(this.saver, this.helper);
        AdvancementHolder collectKey = this.create("light/collect_key").parent(dragonRiderWorkbench).displayItem((ItemLike)DSItems.LIGHT_KEY.value()).showToast().announceChat().criteria("collect_light_key", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.LIGHT_KEY.value()})).build(this.saver, this.helper);
        AdvancementHolder openVault = this.create("light/open_vault").parent(collectKey).displayItem((ItemLike)DSBlocks.LIGHT_VAULT.value()).showToast().announceChat().criteria("open_light_vault", this.itemUsedOnBlock((Block)DSBlocks.LIGHT_VAULT.value(), (ItemLike)DSItems.LIGHT_KEY.value())).experienceReward(10).build(this.saver, this.helper);
        AdvancementHolder getArmorItem = this.create("light/get_armor_item").parent(openVault).displayItem((ItemLike)DSItems.LIGHT_DRAGON_HELMET.value()).showToast().announceChat().criteria("collect_light_armor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.LIGHT_DRAGON_HELMET.value(), (ItemLike)DSItems.LIGHT_DRAGON_CHESTPLATE.value(), (ItemLike)DSItems.LIGHT_DRAGON_LEGGINGS.value(), (ItemLike)DSItems.LIGHT_DRAGON_BOOTS.value()})).build(this.saver, this.helper);
        this.create("light/get_armor_set").parent(getArmorItem).displayItem((ItemLike)DSItems.LIGHT_DRAGON_HELMET.value()).showToast().announceChat().criteria("collect_light_armor_helmet", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.LIGHT_DRAGON_HELMET.value()})).criteria("collect_light_armor_chestplate", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.LIGHT_DRAGON_CHESTPLATE.value()})).criteria("collect_light_armor_leggings", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.LIGHT_DRAGON_LEGGINGS.value()})).criteria("collect_light_armor_boots", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.LIGHT_DRAGON_BOOTS.value()})).build(this.saver, this.helper);
    }

    private void buildHunterAdvancements(AdvancementHolder parent) {
        AdvancementHolder promotion = this.create("hunter/promotion").parent(parent).displayItem((ItemLike)DSItems.SPEARMAN_PROMOTION.value()).showToast().announceChat().criteria("promote_spearman", this.itemInteract((EntityType)DSEntities.HUNTER_SPEARMAN.value(), (ItemLike)DSItems.SPEARMAN_PROMOTION.value())).experienceReward(6).build(this.saver, this.helper);
        AdvancementHolder collectKey = this.create("hunter/collect_key").parent(promotion).displayItem((ItemLike)DSItems.HUNTER_KEY.value()).showToast().announceChat().criteria("collect_hunter_key", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.HUNTER_KEY.value()})).build(this.saver, this.helper);
        AdvancementHolder openVault = this.create("hunter/open_vault").parent(collectKey).displayItem((ItemLike)DSBlocks.HUNTER_VAULT.value()).showToast().announceChat().criteria("open_hunter_vault", this.itemUsedOnBlock((Block)DSBlocks.HUNTER_VAULT.value(), (ItemLike)DSItems.HUNTER_KEY.value())).experienceReward(10).build(this.saver, this.helper);
        Holder.Reference bolas = this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(DSEnchantments.BOLAS);
        this.create("hunter/fire_bolas").parent(openVault).displayItem((ItemLike)DSItems.BOLAS.value()).criteria("fire_bolas", ShotCrossbowTrigger.TriggerInstance.shotCrossbow(Optional.of(ItemPredicate.Builder.item().of(Tags.Items.TOOLS_CROSSBOW).withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)bolas, MinMaxBounds.Ints.atLeast((int)1))))).build()))).build(this.saver, this.helper);
    }

    private void buildPlaceAltarChildren(AdvancementHolder parent) {
        ItemStack caveSoul = ((Item)DSItems.DRAGON_SOUL.value()).getDefaultInstance();
        caveSoul.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(2));
        AdvancementHolder beCaveDragon = this.create("cave/be_dragon").parent(parent).displayItem(caveSoul).showToast().announceChat().criteria("be_cave_dragon", this.beDragon((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.CAVE_DRAGON))).experienceReward(12).build(this.saver, this.helper);
        this.buildBeCaveDragonChildren(beCaveDragon);
        ItemStack seaSoul = ((Item)DSItems.DRAGON_SOUL.value()).getDefaultInstance();
        seaSoul.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(3));
        AdvancementHolder beSeaDragon = this.create("sea/be_dragon").parent(parent).displayItem(seaSoul).showToast().announceChat().criteria("be_sea_dragon", this.beDragon((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.SEA_DRAGON))).experienceReward(12).build(this.saver, this.helper);
        this.buildBeSeaDragonChildren(beSeaDragon);
        ItemStack forestSoul = ((Item)DSItems.DRAGON_SOUL.value()).getDefaultInstance();
        forestSoul.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(1));
        AdvancementHolder beForestDragon = this.create("forest/be_dragon").parent(parent).displayItem(forestSoul).showToast().announceChat().criteria(this.beDragon((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.FOREST_DRAGON))).experienceReward(12).build(this.saver, this.helper);
        this.buildBeForestDragonChildren(beForestDragon);
    }

    private void buildBeCaveDragonChildren(AdvancementHolder parent) {
        AdvancementHolder rockEater = this.create("cave/rock_eater").parent(parent).displayItem((ItemLike)DSItems.CHARGED_COAL.value()).criteria("consume_charged_coal", this.consumeItem((Item)DSItems.CHARGED_COAL.value())).criteria("consume_charged_soup", this.consumeItem((Item)DSItems.CHARGED_SOUP.value())).criteria("consume_charred_meat", this.consumeItem((Item)DSItems.CHARRED_MEAT.value())).criteria("consume_charred_seafood", this.consumeItem((Item)DSItems.CHARRED_SEAFOOD.value())).criteria("consume_hot_dragon_rod", this.consumeItem((Item)DSItems.HOT_DRAGON_ROD.value())).criteria("consume_explosive_copper", this.consumeItem((Item)DSItems.EXPLOSIVE_COPPER.value())).criteria("consume_quartz_explosive_copper", this.consumeItem((Item)DSItems.QUARTZ_EXPLOSIVE_COPPER.value())).criteria("consume_double_quartz", this.consumeItem((Item)DSItems.DOUBLE_QUARTZ.value())).criteria("consume_cave_dragon_treat", this.consumeItem((Item)DSItems.CAVE_DRAGON_TREAT.value())).experienceReward(60).build(this.saver, this.helper);
        AdvancementHolder swimInLava = this.create("cave/swim_in_lava").parent(parent).displayItem((ItemLike)Items.LAVA_BUCKET).criteria("swim_in_lava", this.location(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.CAVE_DRAGON)).located(this.isInFluid((TagKey<Fluid>)FluidTags.LAVA)))).experienceReward(20).build(this.saver, this.helper);
        this.create("cave/water_safety").parent(rockEater).displayItem((ItemLike)DSItems.CHARGED_SOUP.value()).criteria("swim_safely_in_lava", this.location(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.CAVE_DRAGON)).located(this.isInFluid((TagKey<Fluid>)FluidTags.WATER)).effects(MobEffectsPredicate.Builder.effects().and(DSEffects.FIRE)))).experienceReward(40).build(this.saver, this.helper);
        AdvancementHolder diamondsInLava = this.create("cave/diamonds_in_lava").parent(swimInLava).displayItem((ItemLike)Items.DIAMOND_ORE).criteria("mine_diamond_in_lava", this.mineBlockInLava((TagKey<Block>)Tags.Blocks.ORES_DIAMOND)).experienceReward(40).build(this.saver, this.helper);
        this.create("cave/go_home").parent(diamondsInLava).displayItem((ItemLike)Items.NETHER_BRICK_STAIRS).showToast().announceChat().criteria("explore_nether_lava_sea", this.location(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.CAVE_DRAGON)).located(this.inDimension((ResourceKey<Level>)Level.NETHER).setFluid(this.fluid((TagKey<Fluid>)FluidTags.LAVA))).effects(this.hasEffect(DSEffects.LAVA_VISION)))).experienceReward(20).build(this.saver, this.helper);
    }

    private void buildBeSeaDragonChildren(AdvancementHolder parent) {
        AdvancementHolder lootShipwreck = this.create("sea/loot_shipwreck").parent(parent).displayItem((ItemLike)Items.HEART_OF_THE_SEA).criteria("explore_shipwreck", this.location(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.SEA_DRAGON)).located(this.inStructure((Holder<Structure>)this.registries.holderOrThrow(BuiltinStructures.SHIPWRECK))))).criteria("explore_beached_shipwreck", this.location(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.SEA_DRAGON)).located(this.inStructure((Holder<Structure>)this.registries.holderOrThrow(BuiltinStructures.SHIPWRECK_BEACHED))))).experienceReward(20).build(this.saver, this.helper);
        AdvancementHolder rainDancing = this.create("sea/rain_dancing").parent(parent).displayItem((ItemLike)Items.WATER_BUCKET).criteria("experience_rain_and_thunder", this.location(ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[]{this.entityCondition(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.SEA_DRAGON)).build()), WeatherCheck.weather().setRaining(true).setThundering(true).build()}))).experienceReward(30).build(this.saver, this.helper);
        this.create("sea/fish_eater").parent(lootShipwreck).displayItem((ItemLike)DSItems.SEASONED_FISH.value()).criteria("consume_kelp", this.consumeItem(Items.KELP)).criteria("consume_seasoned_fish", this.consumeItem((Item)DSItems.SEASONED_FISH.value())).criteria("consume_golden_coral_pufferfish", this.consumeItem((Item)DSItems.GOLDEN_CORAL_PUFFERFISH.value())).criteria("consume_frozen_raw_fish", this.consumeItem((Item)DSItems.FROZEN_RAW_FISH.value())).criteria("consume_golden_turtle_egg", this.consumeItem((Item)DSItems.GOLDEN_TURTLE_EGG.value())).criteria("consume_sea_dragon_treat", this.consumeItem((Item)DSItems.SEA_DRAGON_TREAT.value())).experienceReward(80).build(this.saver, this.helper);
        AdvancementHolder placeSnowInNether = this.create("sea/place_snow_in_nether").parent(rainDancing).displayItem((ItemLike)Items.SNOW_BLOCK).criteria("place_snow_in_nether", this.placeBlockAsDragon(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.SEA_DRAGON)).located(this.inDimension((ResourceKey<Level>)Level.NETHER)), Blocks.SNOW_BLOCK)).experienceReward(16).build(this.saver, this.helper);
        this.create("sea/peace_in_nether").parent(placeSnowInNether).displayItem((ItemLike)Items.CAULDRON).criteria("be_safe_in_nether", this.location(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.SEA_DRAGON)).effects(this.hasEffect(DSEffects.PEACE)).located(this.inDimension((ResourceKey<Level>)Level.NETHER)))).build(this.saver, this.helper);
    }

    private void buildBeForestDragonChildren(AdvancementHolder parent) {
        AdvancementHolder standOnSweetBerries = this.create("forest/stand_on_sweet_berries").parent(parent).displayItem((ItemLike)Items.SWEET_BERRIES).criteria("stand_on_sweet_berries", this.location(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.FOREST_DRAGON)).steppingOn(this.block(Blocks.SWEET_BERRY_BUSH)))).experienceReward(30).build(this.saver, this.helper);
        AdvancementHolder poisonousPotato = this.create("forest/poisonous_potato").parent(parent).displayItem((ItemLike)Items.POISONOUS_POTATO).criteria("convert_potato", this.convertPotato(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.FOREST_DRAGON)))).experienceReward(16).build(this.saver, this.helper);
        this.create("forest/prevent_darkness_penalty").parent(standOnSweetBerries).displayItem((ItemLike)DSItems.LUMINOUS_OINTMENT.value()).criteria("be_safe_in_darkness", this.location(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.FOREST_DRAGON)).located(this.light(MinMaxBounds.Ints.between((int)0, (int)3))).effects(MobEffectsPredicate.Builder.effects().and(DSEffects.MAGIC)))).experienceReward(40).build(this.saver, this.helper);
        AdvancementHolder meatEater = this.create("forest/meat_eater").parent(poisonousPotato).displayItem((ItemLike)DSItems.MEAT_WILD_BERRIES.value()).criteria("consume_sweet_sour_rabbit", this.consumeItem((Item)DSItems.SWEET_SOUR_RABBIT.value())).criteria("consume_luminous_ointment", this.consumeItem((Item)DSItems.LUMINOUS_OINTMENT.value())).criteria("consume_diamond_chorus", this.consumeItem((Item)DSItems.DIAMOND_CHORUS.value())).criteria("consume_smelly_meat_porridge", this.consumeItem((Item)DSItems.SMELLY_MEAT_PORRIDGE.value())).criteria("consume_meat_wilderness", this.consumeItem((Item)DSItems.MEAT_WILD_BERRIES.value())).criteria("consume_meat_chorus_mix", this.consumeItem((Item)DSItems.MEAT_CHORUS_MIX.value())).criteria("consume_forest_dragon_treat", this.consumeItem((Item)DSItems.FOREST_DRAGON_TREAT.value())).experienceReward(60).build(this.saver, this.helper);
        this.create("forest/transplant_chorus_fruit").parent(meatEater).displayItem((ItemLike)DSItems.DIAMOND_CHORUS.value()).criteria("place_chorus_fruit", this.placeBlockAsDragon(Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.FOREST_DRAGON)).located(this.inDimension((ResourceKey<Level>)Level.OVERWORLD)), Blocks.CHORUS_FLOWER)).experienceReward(90).build(this.saver, this.helper);
    }

    private void buildBeDragonChildren(AdvancementHolder parent) {
        AdvancementHolder stopNaturalGrowth = this.create("stop_natural_growth").parent(parent).displayItem((ItemLike)DSItems.STAR_HEART.value()).showToast().announceChat().criteria("stop_natural_growth", this.stopNaturalGrowth()).experienceReward(30).build(this.saver, this.helper);
        this.create("use_dragon_soul").parent(stopNaturalGrowth).displayItem((ItemLike)DSItems.DRAGON_SOUL.value()).showToast().announceChat().criteria("use_dragon_soul", this.useDragonSoul()).experienceReward(120).build(this.saver, this.helper);
    }

    private void buildCollectDustChildren(AdvancementHolder parent) {
        AdvancementHolder beYoungDragon = this.create("be_young_dragon").parent(parent).displayItem((ItemLike)DSItems.DRAGON_HEART_SHARD.value()).showToast().announceChat().criteria("reach_young_stage", this.beDragon(DragonStages.young)).experienceReward(12).build(this.saver, this.helper);
        this.buildBeYoungDragonChildren(beYoungDragon);
        AdvancementHolder sleepOnTreasure = this.create("sleep_on_treasure").parent(parent).displayItem((ItemLike)Items.GOLD_NUGGET).announceChat().criteria("sleep_on_small_treasure_hoard", this.sleepOnTreasure(10)).experienceReward(10).build(this.saver, this.helper);
        this.buildSleepOnTreasureChildren(sleepOnTreasure);
        TagKey dragonBones = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)DragonSurvival.res("dragon_skeletons"));
        AdvancementHolder findBones = this.create("find_bones").parent(parent).displayItem((ItemLike)DSItems.STAR_BONE.value()).showToast().announceChat().criteria("find_dragon_bones", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)this.inStructure((TagKey<Structure>)dragonBones))).experienceReward(12).build(this.saver, this.helper);
        this.buildFindBonesChildren(findBones);
        AdvancementHolder useMemoryBlock = this.create("use_memory_block").parent(parent).displayItem((ItemLike)DSBlocks.DRAGON_MEMORY_BLOCK.value()).showToast().announceChat().criteria("place_beacon_on_memory_block", this.itemUsedOnBlock((Block)DSBlocks.DRAGON_MEMORY_BLOCK.value(), (ItemLike)DSBlocks.DRAGON_BEACON.value())).experienceReward(10).build(this.saver, this.helper);
        this.buildUseMemoryBlockChildren(useMemoryBlock);
    }

    private void buildFindBonesChildren(AdvancementHolder parent) {
        TagKey lightTreasure = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)DragonSurvival.res("light_treasure"));
        AdvancementHolder findOverworldStructure = this.create("find_overworld_structures").parent(parent).displayItem((ItemLike)Blocks.GRASS_BLOCK).showToast().announceChat().criteria("find_light_treasure", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)this.inStructure((TagKey<Structure>)lightTreasure))).experienceReward(24).build(this.saver, this.helper);
        TagKey darkTreasure = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)DragonSurvival.res("dark_treasure"));
        AdvancementHolder findNetherStructure = this.create("find_nether_structures").parent(findOverworldStructure).displayItem((ItemLike)Blocks.NETHERRACK).showToast().announceChat().criteria("find_dark_treasure", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)this.inStructure((TagKey<Structure>)darkTreasure))).experienceReward(36).build(this.saver, this.helper);
        AdvancementHolder findEndPlatform = this.create("find_end_platform").parent(findNetherStructure).displayItem((ItemLike)Items.ENDER_PEARL).showToast().announceChat().criteria("enter_end_as_dragon", this.beDragon(EntityCondition.inDimension((ResourceKey<Level>)Level.END))).experienceReward(32).build(this.saver, this.helper);
        TagKey endTreasure = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)DragonSurvival.res("treasure_end"));
        this.create("find_end_structures").parent(findEndPlatform).displayItem((ItemLike)DSItems.SPIN_GRANT_ITEM.value()).showToast().announceChat().criteria("find_end_structures", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)this.inStructure((TagKey<Structure>)endTreasure))).experienceReward(64).build(this.saver, this.helper);
    }

    private void buildUseMemoryBlockChildren(AdvancementHolder parent) {
        AdvancementHolder changeBeacon = this.create("change_beacon").parent(parent).displayItem((ItemLike)DSItems.BEACON_ACTIVATOR.value()).showToast().announceChat().criteria("activate_beacon", this.itemUsedOnBlock((Block)DSBlocks.DRAGON_BEACON.value(), (ItemLike)DSItems.BEACON_ACTIVATOR.value())).experienceReward(10).build(this.saver, this.helper);
        this.create("get_all_beacons").parent(changeBeacon).displayItem((ItemLike)DSItems.ELDER_DRAGON_DUST.value()).showToast().announceChat().criteria("affected_by_peace", this.effectWithMinDuration(DSEffects.PEACE, Functions.secondsToTicks(20.0))).criteria("affected_by_fire", this.effectWithMinDuration(DSEffects.FIRE, Functions.secondsToTicks(20.0))).criteria("affected_by_magic", this.effectWithMinDuration(DSEffects.MAGIC, Functions.secondsToTicks(20.0))).build(this.saver, this.helper);
    }

    private void buildSleepOnTreasureChildren(AdvancementHolder parent) {
        AdvancementHolder sleepOnHoard = this.create("sleep_on_hoard").parent(parent).displayItem((ItemLike)Items.GOLD_INGOT).showToast().announceChat().criteria("sleep_on_treasure_hoard", this.sleepOnTreasure(100)).experienceReward(40).build(this.saver, this.helper);
        this.create("sleep_on_massive_hoard").parent(sleepOnHoard).displayItem((ItemLike)DSBlocks.GOLD_DRAGON_TREASURE.value()).showToast().announceChat().criteria("sleep_on_massive_treasure_hoard", this.sleepOnTreasure(240)).experienceReward(120).build(this.saver, this.helper);
    }

    private void buildBeYoungDragonChildren(AdvancementHolder parent) {
        AdvancementHolder beAdultDragon = this.create("be_adult_dragon").parent(parent).displayItem((ItemLike)DSItems.WEAK_DRAGON_HEART.value()).showToast().announceChat().criteria("reach_adult_stage", this.beDragon(DragonStages.adult)).build(this.saver, this.helper);
        AdvancementHolder collectHeartFromMonster = this.create("collect_heart_from_monster").parent(beAdultDragon).displayItem((ItemLike)DSItems.ELDER_DRAGON_HEART.value()).criteria("collect_elder_dragon_heart", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)DSItems.ELDER_DRAGON_HEART.value()})).experienceReward(6).build(this.saver, this.helper);
        AdvancementHolder beOldCaveDragon = this.create("cave/be_old_dragon").parent(collectHeartFromMonster).displayItem((ItemLike)DSItems.CAVE_BEACON.value()).showToast().announceChat().criteria("be_fully_grown_adult", this.beDragon((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.CAVE_DRAGON), (Holder<DragonStage>)this.registries.holderOrThrow(DragonStages.adult), 1.0)).experienceReward(120).build(this.saver, this.helper);
        this.create("cave/master_all_passives").parent(beOldCaveDragon).displayItem((ItemLike)DSBlocks.CAVE_SOURCE_OF_MAGIC.value()).showToast().announceChat().criteria("master_burn", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(CaveDragonAbilities.BURN))).criteria("master_cave_athletics", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(CaveDragonAbilities.CAVE_ATHLETICS))).criteria("master_contrast_shower", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(CaveDragonAbilities.CONTRAST_SHOWER))).criteria("master_cave_magic", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(CaveDragonAbilities.CAVE_MAGIC))).experienceReward(150).build(this.saver, this.helper);
        AdvancementHolder beOldSeaDragon = this.create("sea/be_old_dragon").parent(collectHeartFromMonster).displayItem((ItemLike)DSItems.SEA_BEACON.value()).showToast().announceChat().criteria("be_fully_grown_adult", this.beDragon((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.SEA_DRAGON), (Holder<DragonStage>)this.registries.holderOrThrow(DragonStages.adult), 1.0)).experienceReward(120).build(this.saver, this.helper);
        this.create("sea/master_all_passives").parent(beOldSeaDragon).displayItem((ItemLike)DSBlocks.SEA_SOURCE_OF_MAGIC.value()).showToast().announceChat().criteria("master_spectral_impact", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(SeaDragonAbilities.SPECTRAL_IMPACT))).criteria("master_sea_athletics", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(SeaDragonAbilities.SEA_ATHLETICS))).criteria("master_hydration", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(SeaDragonAbilities.HYDRATION))).criteria("master_sea_magic", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(SeaDragonAbilities.SEA_MAGIC))).experienceReward(150).build(this.saver, this.helper);
        AdvancementHolder beOldForestDragon = this.create("forest/be_old_dragon").parent(collectHeartFromMonster).displayItem((ItemLike)DSItems.FOREST_BEACON.value()).showToast().announceChat().criteria("be_fully_grown_adult", this.beDragon((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.FOREST_DRAGON), (Holder<DragonStage>)this.registries.holderOrThrow(DragonStages.adult), 1.0)).experienceReward(120).build(this.saver, this.helper);
        this.create("forest/master_all_passives").parent(beOldForestDragon).displayItem((ItemLike)DSBlocks.FOREST_SOURCE_OF_MAGIC.value()).showToast().announceChat().criteria("master_cliffhanger", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(ForestDragonAbilities.CLIFFHANGER))).criteria("master_forest_athletics", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(ForestDragonAbilities.FOREST_ATHLETICS))).criteria("master_light_in_darkness", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(ForestDragonAbilities.LIGHT_IN_DARKNESS))).criteria("master_forest_magic", this.upgradeAbilityMax((Holder<DragonAbility>)this.registries.holderOrThrow(ForestDragonAbilities.FOREST_MAGIC))).experienceReward(150).build(this.saver, this.helper);
    }

    private Builder create(String path) {
        return new Builder(path);
    }

    private Criterion<PlayerTrigger.TriggerInstance> tick(EntityPredicate predicate) {
        return CriteriaTriggers.TICK.createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.of(EntityPredicate.wrap((EntityPredicate)predicate))));
    }

    private Criterion<RecipeCraftedTrigger.TriggerInstance> crafted(ItemLike item) {
        return RecipeCraftedTrigger.TriggerInstance.craftedItem((ResourceLocation)item.asItem().builtInRegistryHolder().key().location());
    }

    private LootItemCondition entityCondition(EntityPredicate predicate) {
        return LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)predicate).build();
    }

    @SafeVarargs
    private MobEffectsPredicate.Builder hasEffect(Holder<MobEffect> ... effects) {
        MobEffectsPredicate.Builder builder = MobEffectsPredicate.Builder.effects();
        for (Holder<MobEffect> effect : effects) {
            builder.and(effect);
        }
        return builder;
    }

    private LocationPredicate.Builder inDimension(ResourceKey<Level> dimension) {
        return LocationPredicate.Builder.inDimension(dimension);
    }

    private LocationPredicate.Builder inStructure(TagKey<Structure> tag) {
        HolderSet.Named set = this.registries.lookupOrThrow(Registries.STRUCTURE).getOrThrow(tag);
        return LocationPredicate.Builder.location().setStructures((HolderSet)set);
    }

    private LocationPredicate.Builder inStructure(Holder<Structure> structure) {
        return LocationPredicate.Builder.inStructure(structure);
    }

    private LocationPredicate.Builder isInFluid(TagKey<Fluid> fluids) {
        return LocationPredicate.Builder.location().setFluid(this.fluid(fluids));
    }

    private Optional<ContextAwarePredicate> caveDragonInLava() {
        return Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)Condition.dragonSpecies((Holder<DragonSpecies>)this.registries.holderOrThrow(BuiltInDragonSpecies.CAVE_DRAGON)).located(this.isInFluid((TagKey<Fluid>)FluidTags.LAVA))));
    }

    private FluidPredicate.Builder fluid(TagKey<Fluid> fluids) {
        return FluidPredicate.Builder.fluid().of((HolderSet)this.registries.lookupOrThrow(Registries.FLUID).getOrThrow(fluids));
    }

    private LocationPredicate.Builder block(Block block) {
        return LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}));
    }

    private LocationPredicate.Builder light(MinMaxBounds.Ints bounds) {
        return LocationPredicate.Builder.location().setLight(LightPredicate.Builder.light().setComposite(bounds));
    }

    public Criterion<InventoryChangeTrigger.TriggerInstance> dragonHasItem(Holder<DragonSpecies> dragonSpecies, ItemLike ... items) {
        ArrayList<ItemPredicate> predicates = new ArrayList<ItemPredicate>();
        for (ItemLike item : items) {
            predicates.add(new ItemPredicate(Optional.of(HolderSet.direct((Holder[])new Holder[]{item.asItem().builtInRegistryHolder()})), MinMaxBounds.Ints.ANY, DataComponentPredicate.EMPTY, Map.of()));
        }
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)Condition.dragonSpecies(dragonSpecies))), InventoryChangeTrigger.TriggerInstance.Slots.ANY, predicates));
    }

    public Criterion<PlayerTrigger.TriggerInstance> location(ContextAwarePredicate predicate) {
        return CriteriaTriggers.LOCATION.createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.of(predicate)));
    }

    public Criterion<PlayerTrigger.TriggerInstance> location(EntityPredicate.Builder builder) {
        return CriteriaTriggers.LOCATION.createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)builder))));
    }

    public Criterion<ConsumeItemTrigger.TriggerInstance> consumeItem(Item ... items) {
        return ConsumeItemTrigger.TriggerInstance.usedItem((ItemPredicate.Builder)ItemPredicate.Builder.item().of((ItemLike[])items));
    }

    public Criterion<UsingItemTrigger.TriggerInstance> usingItem(Item item) {
        return CriteriaTriggers.USING_ITEM.createCriterion((CriterionTriggerInstance)new UsingItemTrigger.TriggerInstance(Optional.empty(), Optional.of(ItemPredicate.Builder.item().of(new ItemLike[]{item}).build())));
    }

    public Criterion<ItemUsedOnLocationTrigger.TriggerInstance> placeBlockAsDragon(EntityPredicate.Builder builder, Block block) {
        ContextAwarePredicate blockPredicate = ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[]{LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).build()});
        return CriteriaTriggers.PLACED_BLOCK.createCriterion((CriterionTriggerInstance)new ItemUsedOnLocationTrigger.TriggerInstance(Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)builder)), Optional.of(blockPredicate)));
    }

    public Criterion<ItemUsedOnLocationTrigger.TriggerInstance> placeBlock(Block block) {
        return ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)block);
    }

    public Criterion<ItemUsedOnLocationTrigger.TriggerInstance> placeBlock(TagKey<Item> blocks) {
        return ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((LootItemCondition.Builder[])new LootItemCondition.Builder[]{MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(blocks))});
    }

    public Criterion<ItemUsedOnLocationTrigger.TriggerInstance> itemUsedOnBlock(Block block, ItemLike ... items) {
        return ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block})), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(items));
    }

    public Criterion<ItemUsedOnLocationTrigger.TriggerInstance> itemUsedOnBlock(Block block, TagKey<Item> items) {
        return ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block})), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(items));
    }

    public Criterion<EffectsChangedTrigger.TriggerInstance> effectWithMinDuration(Holder<MobEffect> effect, int minDuration) {
        return EffectsChangedTrigger.TriggerInstance.hasEffects((MobEffectsPredicate.Builder)MobEffectsPredicate.Builder.effects().and(effect, new MobEffectsPredicate.MobEffectInstancePredicate(MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.atLeast((int)minDuration), Optional.empty(), Optional.empty())));
    }

    public Criterion<PlayerInteractTrigger.TriggerInstance> itemInteract(EntityType<?> type, ItemLike ... items) {
        Optional<ContextAwarePredicate> entityPredicate = Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(type)));
        Optional<ItemPredicate> itemPredicate = Optional.of(ItemPredicate.Builder.item().of(items).build());
        return CriteriaTriggers.PLAYER_INTERACTED_WITH_ENTITY.createCriterion((CriterionTriggerInstance)new PlayerInteractTrigger.TriggerInstance(Optional.empty(), itemPredicate, entityPredicate));
    }

    public Criterion<PlayerInteractTrigger.TriggerInstance> noItemInteract(EntityType<?> type) {
        return CriteriaTriggers.PLAYER_INTERACTED_WITH_ENTITY.createCriterion((CriterionTriggerInstance)new PlayerInteractTrigger.TriggerInstance(Optional.empty(), Optional.empty(), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(type)))));
    }

    public Criterion<ConvertItemFromAbility.TriggerInstance> convertPotato(EntityPredicate.Builder builder) {
        return DSAdvancementTriggers.CONVERT_ITEM_FROM_ABILITY.get().createCriterion((CriterionTriggerInstance)new ConvertItemFromAbility.TriggerInstance(Optional.of(EntityPredicate.wrap((EntityPredicate)builder.build())), (Holder<Item>)Items.POTATO.builtInRegistryHolder(), (Holder<Item>)Items.POISONOUS_POTATO.builtInRegistryHolder()));
    }

    public Criterion<MineBlockUnderLavaTrigger.MineBlockUnderLavaInstance> mineBlockInLava(Block ... blocks) {
        return DSAdvancementTriggers.MINE_BLOCK_UNDER_LAVA.get().createCriterion((CriterionTriggerInstance)new MineBlockUnderLavaTrigger.MineBlockUnderLavaInstance(this.caveDragonInLava(), Optional.of(HolderSet.direct(Block::builtInRegistryHolder, (Object[])blocks))));
    }

    public Criterion<MineBlockUnderLavaTrigger.MineBlockUnderLavaInstance> mineBlockInLava(TagKey<Block> blocks) {
        return DSAdvancementTriggers.MINE_BLOCK_UNDER_LAVA.get().createCriterion((CriterionTriggerInstance)new MineBlockUnderLavaTrigger.MineBlockUnderLavaInstance(this.caveDragonInLava(), Optional.of(BuiltInRegistries.BLOCK.getOrCreateTag(blocks))));
    }

    public Criterion<UseDragonSoulTrigger.UseDragonSoulInstance> useDragonSoul() {
        return DSAdvancementTriggers.USE_DRAGON_SOUL.get().createCriterion((CriterionTriggerInstance)new UseDragonSoulTrigger.UseDragonSoulInstance(Optional.empty()));
    }

    public Criterion<StopNaturalGrowthTrigger.Instance> stopNaturalGrowth() {
        return DSAdvancementTriggers.STOP_NATURAL_GROWTH.get().createCriterion((CriterionTriggerInstance)new StopNaturalGrowthTrigger.Instance(Optional.empty()));
    }

    public Criterion<SleepOnTreasureTrigger.SleepOnTreasureInstance> sleepOnTreasure(int nearbyTreasureAmount) {
        return DSAdvancementTriggers.SLEEP_ON_TREASURE.get().createCriterion((CriterionTriggerInstance)new SleepOnTreasureTrigger.SleepOnTreasureInstance(Optional.empty(), Optional.of(nearbyTreasureAmount)));
    }

    public Criterion<UpgradeAbilityTrigger.UpgradeAbilityInstance> upgradeAbilityMax(Holder<DragonAbility> ability) {
        return this.upgradeAbility((ResourceKey<DragonAbility>)ability.getKey(), ((DragonAbility)ability.value()).getMaxLevel());
    }

    public Criterion<UpgradeAbilityTrigger.UpgradeAbilityInstance> upgradeAbility(ResourceKey<DragonAbility> ability, int level) {
        return DSAdvancementTriggers.UPGRADE_ABILITY.get().createCriterion((CriterionTriggerInstance)new UpgradeAbilityTrigger.UpgradeAbilityInstance(Optional.empty(), Optional.of(ability), Optional.of(level)));
    }

    public Criterion<BeDragonTrigger.Instance> beDragon() {
        return DSAdvancementTriggers.BE_DRAGON.get().createCriterion((CriterionTriggerInstance)new BeDragonTrigger.Instance(Optional.empty()));
    }

    public Criterion<BeDragonTrigger.Instance> beDragon(Holder<DragonSpecies> type) {
        return this.beDragon(Condition.dragonSpecies(type).build());
    }

    public Criterion<BeDragonTrigger.Instance> beDragon(double growth) {
        return this.beDragon(Condition.dragonSizeAtLeast(growth).build());
    }

    public Criterion<BeDragonTrigger.Instance> beDragon(ResourceKey<DragonStage> dragonStage) {
        return this.beDragon(Condition.dragonStage((Holder<DragonStage>)this.registries.holderOrThrow(dragonStage)).build());
    }

    public Criterion<BeDragonTrigger.Instance> beDragon(Holder<DragonSpecies> species, Holder<DragonStage> dragonStage, double progress) {
        return this.beDragon(EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)DragonPredicate.Builder.dragon().species(species).stage(dragonStage, MinMaxBounds.Doubles.atLeast((double)progress)).build()).build());
    }

    public Criterion<BeDragonTrigger.Instance> beDragon(EntityPredicate predicate) {
        return DSAdvancementTriggers.BE_DRAGON.get().createCriterion((CriterionTriggerInstance)new BeDragonTrigger.Instance(Optional.of(EntityPredicate.wrap((EntityPredicate)predicate))));
    }

    public Criterion<StealFromVillagerTrigger.Instance> stealFromVillager() {
        return DSAdvancementTriggers.STEAL_FROM_VILLAGER.get().createCriterion((CriterionTriggerInstance)new StealFromVillagerTrigger.Instance(Optional.empty()));
    }
}

