/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen.advancements;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class Builder {
    private final String path;
    private final List<NamedCriterion> criteria = new ArrayList<NamedCriterion>();
    private AdvancementHolder parent;
    private ItemStack displayItem;
    private ResourceLocation background;
    private AdvancementType type = AdvancementType.TASK;
    private int experienceReward;
    private boolean showToast;
    private boolean announceChat;
    private boolean hidden;
    private boolean showDescription = true;

    public Builder(String path) {
        this.path = path;
    }

    public Builder parent(AdvancementHolder parent) {
        this.parent = parent;
        return this;
    }

    public Builder displayItem(ItemStack displayItem) {
        this.displayItem = displayItem;
        return this;
    }

    public Builder displayItem(ItemLike item) {
        this.displayItem = item.asItem().getDefaultInstance();
        return this;
    }

    public Builder background(ResourceLocation background) {
        this.background = background;
        return this;
    }

    public Builder type(AdvancementType type) {
        this.type = type;
        return this;
    }

    public Builder criteria(String key, Criterion<?> criterion) {
        this.criteria.add(new NamedCriterion(key, criterion));
        return this;
    }

    public Builder criteria(Criterion<?> criterion) {
        this.criteria.add(new NamedCriterion(null, criterion));
        return this;
    }

    public Builder experienceReward(int experienceReward) {
        this.experienceReward = experienceReward;
        return this;
    }

    public Builder showToast() {
        this.showToast = true;
        return this;
    }

    public Builder announceChat() {
        this.announceChat = true;
        return this;
    }

    public Builder hidden() {
        this.hidden = true;
        return this;
    }

    public Builder noDescription() {
        this.showDescription = false;
        return this;
    }

    public AdvancementHolder build(Consumer<AdvancementHolder> saver, ExistingFileHelper helper) {
        Advancement.Builder advancement = Advancement.Builder.advancement();
        if (this.parent != null) {
            advancement.parent(this.parent);
        }
        advancement.display(this.displayItem, (Component)Component.translatable((String)Translation.Type.ADVANCEMENT.wrap(this.path)), (Component)(this.showDescription ? Component.translatable((String)Translation.Type.ADVANCEMENT_DESCRIPTION.wrap(this.path)) : Component.empty()), this.background, this.type, this.showToast, this.announceChat, this.hidden);
        int counter = 0;
        for (NamedCriterion criterion : this.criteria) {
            if (criterion.key() == null) {
                advancement.addCriterion("criterion_" + counter, criterion.criterion());
                ++counter;
                continue;
            }
            advancement.addCriterion(criterion.key(), criterion.criterion());
        }
        if (this.experienceReward > 0) {
            advancement.rewards(AdvancementRewards.Builder.experience((int)this.experienceReward));
        }
        return advancement.save(saver, DragonSurvival.res(this.path), helper);
    }

    public record NamedCriterion(@Nullable String key, Criterion<?> criterion) {
    }
}

