/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

@Target(value={ElementType.FIELD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Repeatable(value=Translations.class)
public @interface Translation {
    public String key() default "";

    public Type type() default Type.NONE;

    public String locale() default "en_us";

    public String[] comments();

    public static enum Type {
        ITEM("item.dragonsurvival.", ""),
        BLOCK("block.dragonsurvival.", ""),
        ENTITY("entity.dragonsurvival.", ""),
        FLUID("fluid.dragonsurvival.", ""),
        ATTRIBUTE("attribute.dragonsurvival.", ""),
        ATTRIBUTE_DESCRIPTION("attribute.dragonsurvival.", ".desc"),
        EFFECT("effect.dragonsurvival.", ""),
        EFFECT_DESCRIPTION("effect.dragonsurvival.", ".desc"),
        ENCHANTMENT("enchantment.dragonsurvival.", ""),
        ENCHANTMENT_DESCRIPTION("enchantment.dragonsurvival.", ".desc"),
        DEATH("death.attack.dragonsurvival.", ""),
        DEATH_PLAYER("death.attack.dragonsurvival.", ".player"),
        DEATH_ITEM("death.attack.dragonsurvival.", ".item"),
        DAMAGE_TYPE("damage_type.dragonsurvival.", ""),
        DESCRIPTION("dragonsurvival.description.", ""),
        DESCRIPTION_ADDITION("dragonsurvival.description.addition.", ""),
        GUI("dragonsurvival.gui.", ""),
        KEYBIND("dragonsurvival.keybind.", ""),
        ADVANCEMENT("dragonsurvival.advancement.", ""),
        ADVANCEMENT_DESCRIPTION("dragonsurvival.advancement.", ".desc"),
        CONFIGURATION("dragonsurvival.configuration.", ".tooltip"),
        ABILITY("dragon_ability.dragonsurvival.", ""),
        ABILITY_DESCRIPTION("dragon_ability.dragonsurvival.", ".desc"),
        DRAGON_SPECIES("dragon_species.dragonsurvival.", ""),
        DRAGON_SPECIES_ALTAR_DESCRIPTION("dragon_species.dragonsurvival.", ".altar.desc"),
        DRAGON_SPECIES_INVENTORY_DESCRIPTION("dragon_species.dragonsurvival.", ".banner.desc"),
        DRAGON_SPECIES_LOCKED("dragon_species.dragonsurvival.", ".locked"),
        PENALTY("dragon_penalty.dragonsurvival.", ""),
        PENALTY_DESCRIPTION("dragon_penalty.dragonsurvival.", ".desc"),
        PROJECTILE("projectile.dragonsurvival.", ""),
        SKIN_PART("skin_part.dragonsurvival.", ""),
        EMOTE("dragon_emote.dragonsurvival.", ""),
        BODY("dragon_body.dragonsurvival.", ""),
        BODY_DESCRIPTION("dragon_body.dragonsurvival.", ".desc"),
        BODY_WINGS("dragon_body.dragonsurvival.", ".wings"),
        BODY_WINGS_DESCRIPTION("dragon_body.dragonsurvival.", ".wings.desc"),
        STAGE("dragon_stage.dragonsurvival.", ""),
        STAGE_DESCRIPTION("dragon_stage.dragonsurvival.", ".desc"),
        COMMAND("command.dragonsurvival.", ""),
        VILLAGER_PROFESSION("entity.minecraft.villager.dragonsurvival.", ""),
        NONE("", "");

        public final String prefix;
        public final String suffix;

        private Type(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String wrap(String key) {
            return this.prefix + key + this.suffix;
        }

        public String wrap(Holder<?> holder) {
            return this.wrap(holder.getKey());
        }

        public String wrap(ResourceKey<?> key) {
            return this.wrap(key.location());
        }

        public String wrap(ResourceLocation location) {
            return this.wrap(location.getNamespace(), location.getPath());
        }

        public String wrap(String modid, String key) {
            return this.prefix.replace("dragonsurvival", modid) + key + this.suffix;
        }

        public String unwrap(String key) {
            return key.substring(this.prefix.length(), key.length() - this.suffix.length());
        }
    }

    @Target(value={ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Translations {
        public Translation[] value();
    }
}

