/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.datagen;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.compat.ModCheck;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEnchantments;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.BlockLootTableSubProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.DSRecipes;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.DataBlockModelProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.DataBlockStateProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.DataItemModelProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.DataSpriteSourceProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.compat.CreateDatapack;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.compat.SilentGemsDatapack;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.data_maps.BodyIconProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.data_maps.DietEntryProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.data_maps.DragonBeaconDataProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.data_maps.EndPlatformProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.data_maps.StageResourceProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.DSLanguageProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSBlockTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDamageTypeTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDragonAbilityTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDragonBodyTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDragonPenaltyTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDragonSpeciesTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSEffectTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSEnchantmentTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSEntityTypeTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSItemTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSPoiTypeTags;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSProfessionTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.BuiltInDragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBodies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmoteSet;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmoteSets;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.datapacks.AncientDatapack;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.datapacks.UnlockWingsDatapack;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalties;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStages;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.ProjectileData;
import by.dragonsurvivalteam.dragonsurvival.registry.projectile.Projectiles;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    private static final String ANCIENT_STAGE_DATAPACK = "ancient_stage";
    @Translation(comments={"Adds the Ancient dragon stage to Dragon Survival"})
    private static final String ANCIENT_STAGE_DATAPACK_DESCRIPTION = Translation.Type.GUI.wrap("datapack.ancient_stage");
    private static final String UNLOCK_WINGS_DATAPACK = "unlock_wings";
    @Translation(comments={"Automatically unlocks dragon wings and prevents the ender dragon from disabling them in Dragon Survival"})
    private static final String UNLOCK_WINGS_DATAPACK_DESCRIPTION = Translation.Type.GUI.wrap("datapack.unlock_wings");
    private static final String SILENT_GEMS_DATAPACK = "silentgems";
    @Translation(comments={"Adds loot tables to the Silent Gems treasures"})
    private static final String SILENT_GEMS_DATAPACK_DESCRIPTION = Translation.Type.GUI.wrap("datapack.silentgems");
    private static final String CREATE_DATAPACK = "create";
    @Translation(comments={"Adds loot tables to the Create treasures"})
    private static final String CREATE_DATAPACK_DESCRIPTION = Translation.Type.GUI.wrap("datapack.create");

    @SubscribeEvent
    public static void generateData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookup = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new DataBlockStateProvider(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new DataItemModelProvider(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new DataSpriteSourceProvider(output, lookup, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new DSLanguageProvider(output, lookup, "en_us"));
        LootTableProvider.SubProviderEntry blockLootTableSubProvider = new LootTableProvider.SubProviderEntry(BlockLootTableSubProvider::new, LootContextParamSets.BLOCK);
        generator.addProvider(event.includeServer(), lootTableOutput -> new LootTableProvider(lootTableOutput, Collections.emptySet(), List.of(blockLootTableSubProvider), event.getLookupProvider()));
        if (event.includeServer()) {
            DataGeneration.addSilentGemsLootTables(generator, lookup);
            DataGeneration.addCreateLootTables(generator, lookup);
        }
        RegistrySetBuilder builder = new RegistrySetBuilder();
        builder.add(Registries.DAMAGE_TYPE, DSDamageTypes::registerDamageTypes);
        builder.add(Registries.ENCHANTMENT, DSEnchantments::registerEnchantments);
        builder.add(DragonEmoteSet.REGISTRY, DragonEmoteSets::registerEmoteSets);
        builder.add(DragonBody.REGISTRY, DragonBodies::registerBodies);
        builder.add(DragonStage.REGISTRY, DragonStages::registerStages);
        builder.add(DragonAbility.REGISTRY, DragonAbilities::registerAbilities);
        builder.add(ProjectileData.REGISTRY, Projectiles::registerProjectiles);
        builder.add(DragonPenalty.REGISTRY, DragonPenalties::registerPenalties);
        builder.add(DragonSpecies.REGISTRY, BuiltInDragonSpecies::registerTypes);
        DatapackBuiltinEntriesProvider datapackProvider = new DatapackBuiltinEntriesProvider(output, lookup, builder, Set.of("dragonsurvival"));
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        lookup = datapackProvider.getRegistryProvider();
        DataGeneration.addAncientStageDatapack(generator, lookup);
        DataGeneration.addUnlockWingsDatapack(generator, lookup, (HolderLookup.RegistryLookup<DragonAbility>)((HolderLookup.Provider)lookup.join()).lookupOrThrow(DragonAbility.REGISTRY));
        DSBlockTags blockTagsProvider = new DSBlockTags(output, lookup, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new DSItemTags(output, lookup, blockTagsProvider.contentsGetter(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSDamageTypeTags(output, lookup, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSEntityTypeTags(output, lookup, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSEffectTags(output, lookup, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSPoiTypeTags(output, lookup, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSProfessionTags(output, lookup, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSEnchantmentTags(output, lookup, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSDragonBodyTags(output, lookup, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSDragonAbilityTags(output, lookup, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSDragonPenaltyTags(output, lookup, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSDragonSpeciesTags(output, lookup, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DietEntryProvider(output, lookup));
        generator.addProvider(event.includeServer(), (DataProvider)new EndPlatformProvider(output, lookup));
        generator.addProvider(event.includeServer(), (DataProvider)new DragonBeaconDataProvider(output, lookup));
        generator.addProvider(event.includeServer(), (DataProvider)new StageResourceProvider(output, lookup));
        generator.addProvider(event.includeServer(), (DataProvider)new BodyIconProvider(output, lookup));
        generator.addProvider(event.includeServer(), (DataProvider)new DataBlockModelProvider(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DSRecipes(output, lookup));
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            DataGeneration.registerBuiltinResourcePack(event, Component.literal((String)"DS - Draconized Armor"), "resourcepacks/draconized_armor");
            DataGeneration.registerBuiltinResourcePack(event, Component.literal((String)"DS - Dark GUI"), "resourcepacks/ds_dark_gui");
        } else if (event.getPackType() == PackType.SERVER_DATA) {
            DataGeneration.registerDataPack(event, Component.literal((String)"DS - Ancient Dragons"), ANCIENT_STAGE_DATAPACK);
            DataGeneration.registerDataPack(event, Component.literal((String)"DS - Unlock Wings"), UNLOCK_WINGS_DATAPACK);
            if (ModCheck.isModLoaded(SILENT_GEMS_DATAPACK)) {
                DataGeneration.registerBuiltInDataPack(event, Component.literal((String)"DS - Silent Gems"), SILENT_GEMS_DATAPACK);
            }
            if (ModCheck.isModLoaded(CREATE_DATAPACK)) {
                DataGeneration.registerBuiltInDataPack(event, Component.literal((String)"DS - Create"), CREATE_DATAPACK);
            }
        }
    }

    private static void registerBuiltinResourcePack(AddPackFindersEvent event, MutableComponent name, String folder) {
        event.addPackFinders(DragonSurvival.res(folder), PackType.CLIENT_RESOURCES, (Component)name, PackSource.BUILT_IN, false, Pack.Position.TOP);
    }

    private static void registerDataPack(AddPackFindersEvent event, MutableComponent name, String datapack) {
        event.addPackFinders(DragonSurvival.res("data/dragonsurvival/datapacks/" + datapack), PackType.SERVER_DATA, (Component)name, PackSource.DEFAULT, false, Pack.Position.TOP);
    }

    private static void registerBuiltInDataPack(AddPackFindersEvent event, MutableComponent name, String datapack) {
        event.addPackFinders(DragonSurvival.res("data/dragonsurvival/datapacks/" + datapack), PackType.SERVER_DATA, (Component)name, PackSource.BUILT_IN, true, Pack.Position.TOP);
    }

    private static void addAncientStageDatapack(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookup) {
        DataGenerator.PackGenerator datapack = generator.getBuiltinDatapack(true, "dragonsurvival", ANCIENT_STAGE_DATAPACK);
        datapack.addProvider(output -> PackMetadataGenerator.forFeaturePack((PackOutput)output, (Component)Component.translatable((String)ANCIENT_STAGE_DATAPACK_DESCRIPTION), (FeatureFlagSet)FeatureFlagSet.of()));
        RegistrySetBuilder builder = new RegistrySetBuilder();
        builder.add(DragonStage.REGISTRY, AncientDatapack::register);
        datapack.addProvider(output -> new DatapackBuiltinEntriesProvider(output, lookup, builder, Set.of("dragonsurvival")));
    }

    private static void addUnlockWingsDatapack(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookup, HolderLookup.RegistryLookup<DragonAbility> registryLookup) {
        DataGenerator.PackGenerator datapack = generator.getBuiltinDatapack(true, "dragonsurvival", UNLOCK_WINGS_DATAPACK);
        datapack.addProvider(output -> PackMetadataGenerator.forFeaturePack((PackOutput)output, (Component)Component.translatable((String)UNLOCK_WINGS_DATAPACK_DESCRIPTION), (FeatureFlagSet)FeatureFlagSet.of()));
        RegistrySetBuilder builder = new RegistrySetBuilder();
        builder.add(DragonAbility.REGISTRY, context -> UnlockWingsDatapack.register((BootstrapContext<DragonAbility>)context, registryLookup));
        datapack.addProvider(output -> new DatapackBuiltinEntriesProvider(output, lookup, builder, Set.of("dragonsurvival")));
    }

    private static void addSilentGemsLootTables(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookup) {
        DataGenerator.PackGenerator datapack = generator.getBuiltinDatapack(true, "dragonsurvival", SILENT_GEMS_DATAPACK);
        datapack.addProvider(output -> PackMetadataGenerator.forFeaturePack((PackOutput)output, (Component)Component.translatable((String)SILENT_GEMS_DATAPACK_DESCRIPTION), (FeatureFlagSet)FeatureFlagSet.of()));
        LootTableProvider.SubProviderEntry subProvider = new LootTableProvider.SubProviderEntry(SilentGemsDatapack::new, LootContextParamSets.BLOCK);
        datapack.addProvider(output -> new SilentGemsDatapack.Provider(output, Collections.emptySet(), List.of(subProvider), lookup));
    }

    private static void addCreateLootTables(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookup) {
        DataGenerator.PackGenerator datapack = generator.getBuiltinDatapack(true, "dragonsurvival", CREATE_DATAPACK);
        datapack.addProvider(output -> PackMetadataGenerator.forFeaturePack((PackOutput)output, (Component)Component.translatable((String)CREATE_DATAPACK_DESCRIPTION), (FeatureFlagSet)FeatureFlagSet.of()));
        LootTableProvider.SubProviderEntry subProvider = new LootTableProvider.SubProviderEntry(CreateDatapack::new, LootContextParamSets.BLOCK);
        datapack.addProvider(output -> new CreateDatapack.Provider(output, Collections.emptySet(), List.of(subProvider), lookup));
    }
}

