/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.Storage;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SummonData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.common_effects.SummonEntityEffect;
import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class SummonedEntities
extends Storage<SummonEntityEffect.Instance> {
    public static final String MOVEMENT_BEHAVIOUR = "movement_behaviour";
    public static final String ATTACK_BEHAVIOUR = "attack_behaviour";
    public MovementBehaviour movementBehaviour = MovementBehaviour.FOLLOW;
    public AttackBehaviour attackBehaviour = AttackBehaviour.DEFENSIVE;

    @Nullable
    public SummonEntityEffect.Instance getInstance(Entity entity) {
        for (SummonEntityEffect.Instance instance : this.all()) {
            if (!instance.entityUUIDs().contains(entity.getUUID())) continue;
            return instance;
        }
        return null;
    }

    public static boolean hasSummonRelationship(Entity entity, Entity target) {
        if (entity == null || target == null) {
            return false;
        }
        return entity.getExistingData(DSDataAttachments.SUMMON).map(data -> {
            if (!data.isAllied) {
                return false;
            }
            if (data.isOwner(target)) {
                return true;
            }
            SummonData targetData = target.getExistingData(DSDataAttachments.SUMMON).orElse(null);
            if (targetData == null || !targetData.isAllied) {
                return false;
            }
            LivingEntity owner = data.getOwner(entity.level());
            if (owner == null) {
                return false;
            }
            return targetData.isOwner((Entity)owner);
        }).orElse(false);
    }

    @SubscribeEvent
    public static void tickData(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getExistingData(DSDataAttachments.SUMMONED_ENTITIES).ifPresent(data -> {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    boolean requiresSync = false;
                    for (SummonEntityEffect.Instance instance : data.all()) {
                        if (!instance.initializeSummons(serverPlayer)) continue;
                        requiresSync = true;
                    }
                    if (requiresSync) {
                        data.sync(serverPlayer);
                    }
                }
                data.tick((Entity)player);
                if (data.isEmpty()) {
                    player.removeData(DSDataAttachments.SUMMONED_ENTITIES);
                }
            });
        }
    }

    @SubscribeEvent
    public static void discardSummon(PlayerInteractEvent.EntityInteract event) {
        if (event.getHand() != InteractionHand.OFF_HAND || !event.getItemStack().isEmpty() || !event.getEntity().isCrouching()) {
            return;
        }
        event.getEntity().getExistingData(DSDataAttachments.SUMMONED_ENTITIES).ifPresent(data -> {
            SummonEntityEffect.Instance instance = data.getInstance(event.getTarget());
            if (instance == null) {
                return;
            }
            if (instance.removeSummon(event.getTarget())) {
                data.remove((Entity)event.getEntity(), instance);
            }
            event.getTarget().discard();
        });
    }

    @SubscribeEvent
    public static void removeSummons(LivingDeathEvent event) {
        Level level = event.getEntity().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getExistingData(DSDataAttachments.SUMMONED_ENTITIES).ifPresent(data -> data.clear((Entity)player));
            return;
        }
        event.getEntity().getExistingData(DSDataAttachments.SUMMON).ifPresent(data -> {
            LivingEntity owner = data.getOwner((Level)serverLevel);
            if (owner != null) {
                SummonedEntities summonData = (SummonedEntities)owner.getData(DSDataAttachments.SUMMONED_ENTITIES);
                SummonEntityEffect.Instance instance = summonData.getInstance((Entity)event.getEntity());
                if (instance == null) {
                    return;
                }
                if (instance.removeSummon((Entity)event.getEntity())) {
                    summonData.remove((Entity)owner, instance);
                }
                if (summonData.isEmpty()) {
                    owner.removeData(DSDataAttachments.SUMMONED_ENTITIES);
                }
            }
        });
    }

    @SubscribeEvent
    public static void removeSummons(PlayerEvent.PlayerLoggedOutEvent event) {
        event.getEntity().getExistingData(DSDataAttachments.SUMMONED_ENTITIES).ifPresent(data -> data.clear((Entity)event.getEntity()));
    }

    @SubscribeEvent
    public static void targetAttackedEnemy(LivingChangeTargetEvent event) {
        if (event.getNewAboutToBeSetTarget() == null) {
            return;
        }
        if (event.getEntity().getExistingData(DSDataAttachments.SUMMON).map(data -> data.attackBehaviour == AttackBehaviour.PASSIVE).orElse(false).booleanValue()) {
            event.setNewAboutToBeSetTarget(null);
            return;
        }
        if (SummonedEntities.hasSummonRelationship((Entity)event.getEntity(), (Entity)event.getNewAboutToBeSetTarget())) {
            event.setNewAboutToBeSetTarget(null);
        }
    }

    @SubscribeEvent
    public static void avoidDamagingAlly(EntityInvulnerabilityCheckEvent event) {
        if (SummonedEntities.hasSummonRelationship(event.getEntity(), event.getSource().getEntity())) {
            event.setInvulnerable(true);
        }
    }

    @SubscribeEvent
    public static void markPlayerDamage(LivingDamageEvent.Post event) {
        Entity entity = event.getSource().getEntity();
        if (entity == null) {
            return;
        }
        entity.getExistingData(DSDataAttachments.SUMMON).ifPresent(data -> {
            LivingEntity patt0$temp;
            if (data.isAllied && (patt0$temp = data.getOwner(entity.level())) instanceof Player) {
                Player player = (Player)patt0$temp;
                event.getEntity().setLastHurtByPlayer(player);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void skipLoot(LivingDropsEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        event.getEntity().getExistingData(DSDataAttachments.SUMMON).ifPresent(data -> {
            if (data.getOwner(event.getEntity().level()) != null) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void skipExperience(LivingExperienceDropEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        event.getEntity().getExistingData(DSDataAttachments.SUMMON).ifPresent(data -> {
            if (data.getOwner(event.getEntity().level()) != null) {
                event.setCanceled(true);
            }
        });
    }

    @Override
    protected Tag save(@NotNull HolderLookup.Provider provider, SummonEntityEffect.Instance entry) {
        return entry.save(provider);
    }

    @Override
    protected SummonEntityEffect.Instance load(@NotNull HolderLookup.Provider provider, CompoundTag tag) {
        return SummonEntityEffect.Instance.load(provider, tag);
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.putInt(MOVEMENT_BEHAVIOUR, this.movementBehaviour.ordinal());
        tag.putInt(ATTACK_BEHAVIOUR, this.attackBehaviour.ordinal());
        return tag;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        super.deserializeNBT(provider, tag);
        this.movementBehaviour = MovementBehaviour.values()[tag.getInt(MOVEMENT_BEHAVIOUR)];
        this.attackBehaviour = AttackBehaviour.values()[tag.getInt(ATTACK_BEHAVIOUR)];
    }

    @Override
    public AttachmentType<?> type() {
        return (AttachmentType)DSDataAttachments.SUMMONED_ENTITIES.get();
    }

    @Translation(comments={"Movement Behaviour"})
    public static enum MovementBehaviour implements StringRepresentable
    {
        DEFAULT,
        FOLLOW,
        STAY;

        public static final Codec<MovementBehaviour> CODEC;

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            CODEC = StringRepresentable.fromValues(MovementBehaviour::values);
        }
    }

    @Translation(comments={"Attack Behaviour"})
    public static enum AttackBehaviour implements StringRepresentable
    {
        DEFAULT,
        PASSIVE,
        DEFENSIVE;

        public static final Codec<AttackBehaviour> CODEC;

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            CODEC = StringRepresentable.fromValues(AttackBehaviour::values);
        }
    }
}

