/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncPenaltySupply;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncPenaltySupplyAmount;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.SupplyTrigger;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class PenaltySupply
implements INBTSerializable<CompoundTag> {
    private final HashMap<ResourceLocation, Data> supplyData = new HashMap();

    public boolean hasSupply(ResourceLocation supplyType) {
        Data data = this.supplyData.get(supplyType);
        if (data == null) {
            return false;
        }
        return data.getSupply() > 0.0f;
    }

    public void setSupply(ResourceLocation supplyType, float supply) {
        Data data = this.supplyData.get(supplyType);
        if (data != null) {
            data.currentSupply = supply;
        }
    }

    public float getPercentage(ResourceLocation supplyType) {
        Data data = this.supplyData.get(supplyType);
        if (data == null) {
            return 0.0f;
        }
        return data.getSupply() / data.getMaximumSupply();
    }

    public float getRawSupply(ResourceLocation supplyType) {
        Data data = this.supplyData.get(supplyType);
        if (data == null) {
            return 0.0f;
        }
        return data.getSupply();
    }

    public int getMaxSupply(ResourceLocation supplyType) {
        Data data = this.supplyData.get(supplyType);
        if (data == null) {
            return -1;
        }
        return (int)data.getMaximumSupply();
    }

    public void reduce(ServerPlayer player, ResourceLocation supplyType) {
        Data data = this.supplyData.get(supplyType);
        if (data == null) {
            return;
        }
        if (data.reduce()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncPenaltySupplyAmount(supplyType, data.getSupply()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void regenerate(ServerPlayer player, ResourceLocation supplyType) {
        Data data = this.supplyData.get(supplyType);
        if (data == null) {
            return;
        }
        if (data.regenerate()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncPenaltySupplyAmount(supplyType, data.getSupply()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public Optional<Holder<DragonPenalty>> getMatchingPenalty(ResourceLocation supplyType, DragonStateHandler handler) {
        if (handler.species() == null) {
            return Optional.empty();
        }
        for (Holder penalty : ((DragonSpecies)handler.species().value()).penalties()) {
            SupplyTrigger supplyTrigger;
            PenaltyTrigger penaltyTrigger = ((DragonPenalty)penalty.value()).trigger();
            if (!(penaltyTrigger instanceof SupplyTrigger) || !(supplyTrigger = (SupplyTrigger)penaltyTrigger).supplyType().equals((Object)supplyType)) continue;
            return Optional.of(penalty);
        }
        return Optional.empty();
    }

    public void initialize(ResourceLocation supplyType, float maximumSupply, float reductionRate, float regenerationRate, float currentSupply) {
        this.supplyData.put(supplyType, new Data(maximumSupply, Math.min(currentSupply, maximumSupply), reductionRate, regenerationRate));
    }

    public void sync(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncPenaltySupply(this.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public List<ResourceLocation> getSupplyTypes() {
        return List.copyOf(this.supplyData.keySet());
    }

    public void remove(ResourceLocation supplyType) {
        this.supplyData.remove(supplyType);
    }

    public static void clear(Player player) {
        player.getExistingData(DSDataAttachments.PENALTY_SUPPLY).ifPresent(data -> {
            data.supplyData.clear();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                data.sync(serverPlayer);
            }
            player.removeData(DSDataAttachments.PENALTY_SUPPLY);
        });
    }

    @SubscribeEvent
    public static void onRegenerationItemConsumed(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        player.getExistingData(DSDataAttachments.PENALTY_SUPPLY).ifPresent(data -> data.replenishSupplyFromItemStack(player, event.getItem()));
    }

    private void replenishSupplyFromItemStack(ServerPlayer player, ItemStack stack) {
        if (stack.isEmpty()) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData((Player)player);
        this.supplyData.forEach((supplyType, data) -> {
            if (stack.isEmpty() || data.currentSupply == data.maximumSupply) {
                return;
            }
            Optional<Holder<DragonPenalty>> penalty = this.getMatchingPenalty((ResourceLocation)supplyType, handler);
            if (penalty.isEmpty()) {
                return;
            }
            PenaltyTrigger patt0$temp = ((DragonPenalty)penalty.get().value()).trigger();
            if (patt0$temp instanceof SupplyTrigger) {
                SupplyTrigger trigger = (SupplyTrigger)patt0$temp;
                for (SupplyTrigger.RecoveryItem recovery : trigger.recoveryItems()) {
                    if (!recovery.itemPredicates().stream().anyMatch(predicate -> predicate.test(stack))) continue;
                    this.regenerateManual(player, (ResourceLocation)supplyType, recovery.percentRestored());
                    stack.consume(1, (LivingEntity)player);
                    break;
                }
            }
        });
    }

    private void regenerateManual(ServerPlayer player, ResourceLocation supplyType, float amount) {
        Data data = this.supplyData.get(supplyType);
        if (data == null) {
            return;
        }
        data.regeneratePercentage(amount);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncPenaltySupplyAmount(supplyType, data.getSupply()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.supplyData.forEach((supplyType, value) -> tag.put(supplyType.toString(), (Tag)value.serializeNBT()));
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        this.supplyData.clear();
        tag.getAllKeys().forEach(supplyType -> {
            ResourceLocation resource = ResourceLocation.tryParse((String)supplyType);
            if (resource != null) {
                this.supplyData.put(resource, Data.deserializeNBT(tag.getCompound(supplyType)));
            }
        });
    }

    private static class Data {
        private static final String MAXIMUM_SUPPLY = "maximum_supply";
        private static final String CURRENT_SUPPLY = "current_supply";
        private static final String REDUCTION_RATE = "reduction_rate";
        private static final String REGENERATION_RATE = "regeneration_rate";
        private final float maximumSupply;
        private float currentSupply;
        private final float reductionRate;
        private final float regenerationRate;

        public Data(float maximumSupply, float currentSupply, float reductionRate, float regenerationRate) {
            this.maximumSupply = maximumSupply;
            this.currentSupply = currentSupply;
            this.reductionRate = reductionRate;
            this.regenerationRate = regenerationRate;
        }

        public float getSupply() {
            return this.currentSupply;
        }

        public float getMaximumSupply() {
            return this.maximumSupply;
        }

        public boolean reduce() {
            float oldSupply = this.currentSupply;
            this.currentSupply = Math.max(0.0f, this.currentSupply - this.reductionRate);
            return oldSupply != this.currentSupply;
        }

        public boolean regenerate() {
            float oldSupply = this.currentSupply;
            this.currentSupply = Math.min(this.maximumSupply, this.currentSupply + this.maximumSupply * this.regenerationRate);
            return oldSupply != this.currentSupply;
        }

        public void regeneratePercentage(float amount) {
            this.currentSupply = Math.min(this.maximumSupply, this.currentSupply + this.maximumSupply * amount);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.putFloat(MAXIMUM_SUPPLY, this.maximumSupply);
            tag.putFloat(CURRENT_SUPPLY, this.currentSupply);
            tag.putFloat(REDUCTION_RATE, this.reductionRate);
            tag.putFloat(REGENERATION_RATE, this.regenerationRate);
            return tag;
        }

        public static Data deserializeNBT(@NotNull CompoundTag tag) {
            float maximumSupply = tag.getFloat(MAXIMUM_SUPPLY);
            float currentSupply = tag.getFloat(CURRENT_SUPPLY);
            float reductionRate = tag.getFloat(REDUCTION_RATE);
            float regenerationRate = tag.getFloat(REGENERATION_RATE);
            return new Data(maximumSupply, currentSupply, reductionRate, regenerationRate);
        }
    }
}

