/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.ModifierWithDuration;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncModifierWithDuration;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.Storage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class ModifiersWithDuration
extends Storage<ModifierWithDuration.Instance> {
    @SubscribeEvent
    public static void tickData(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.getExistingData(DSDataAttachments.MODIFIERS_WITH_DURATION).ifPresent(data -> {
                data.tick(event.getEntity());
                if (data.isEmpty()) {
                    livingEntity.removeData(DSDataAttachments.MODIFIERS_WITH_DURATION);
                }
            });
        }
    }

    @Override
    public void sync(ServerPlayer player) {
        if (this.storage == null) {
            return;
        }
        for (ModifierWithDuration.Instance modifier : this.storage.values()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncModifierWithDuration(player.getId(), modifier, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    protected Tag save(@NotNull HolderLookup.Provider provider, ModifierWithDuration.Instance entry) {
        return entry.save(provider);
    }

    @Override
    protected ModifierWithDuration.Instance load(@NotNull HolderLookup.Provider provider, CompoundTag tag) {
        return ModifierWithDuration.Instance.load(provider, tag);
    }

    @Override
    public AttachmentType<?> type() {
        return (AttachmentType)DSDataAttachments.MODIFIERS_WITH_DURATION.get();
    }
}

