/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Fear;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.Storage;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class FearData
extends Storage<Fear.Instance> {
    public static final int NO_FEAR = -1;

    public Data getData(Entity entity) {
        int distance = -1;
        float walkSpeed = 1.0f;
        float sprintSpeed = 1.3f;
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return new Data(distance, walkSpeed, sprintSpeed);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (Fear.Instance instance : this.all()) {
            if (instance.distance() == -1 || !((Fear)instance.baseData()).entityCondition().map(condition -> condition.test((Object)Condition.entityContext(serverLevel, entity))).orElse(true).booleanValue()) continue;
            if (instance.distance() > distance) {
                distance = instance.distance();
            }
            if (instance.walkSpeed() > walkSpeed) {
                walkSpeed = instance.walkSpeed();
            }
            if (!(instance.sprintSpeed() > sprintSpeed)) continue;
            sprintSpeed = instance.sprintSpeed();
        }
        return new Data(distance, walkSpeed, sprintSpeed);
    }

    @SubscribeEvent
    public static void tickData(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getExistingData(DSDataAttachments.FEAR).ifPresent(storage -> {
                storage.tick((Entity)player);
                if (storage.isEmpty()) {
                    player.removeData(storage.type());
                }
            });
        }
    }

    @Override
    protected Tag save(@NotNull HolderLookup.Provider provider, Fear.Instance entry) {
        return entry.save(provider);
    }

    @Override
    protected Fear.Instance load(@NotNull HolderLookup.Provider provider, CompoundTag tag) {
        return Fear.Instance.load(provider, tag);
    }

    @Override
    public AttachmentType<?> type() {
        return (AttachmentType)DSDataAttachments.FEAR.value();
    }

    public record Data(int distance, float walkSpeed, float sprintSpeed) {
    }
}

