/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry;

import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.AmbusherEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.GriffinEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.HoundEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.KnightEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.LeaderEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.SpearmanEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.Bolas;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.GenericArrowEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.GenericBallEntity;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.google.common.collect.ImmutableSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DSEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"dragonsurvival");
    @Translation(type=Translation.Type.ENTITY, comments={"Dragon"})
    public static DeferredHolder<EntityType<?>, EntityType<DragonEntity>> DRAGON = REGISTRY.register("dummy_dragon", () -> new EntityType(DragonEntity::new, MobCategory.MISC, true, false, false, false, ImmutableSet.of(), EntityDimensions.fixed((float)0.9f, (float)1.9f), 1.0f, 0, 0, FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA)));
    @Translation(type=Translation.Type.ENTITY, comments={"Bolas"})
    public static DeferredHolder<EntityType<?>, EntityType<Bolas>> BOLAS_ENTITY = REGISTRY.register("bolas", () -> EntityType.Builder.of((entity, level) -> new Bolas(level), (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build("bolas"));
    @Translation(type=Translation.Type.ENTITY, comments={"Generic Ball Entity"})
    public static DeferredHolder<EntityType<?>, EntityType<GenericBallEntity>> GENERIC_BALL_ENTITY = REGISTRY.register("generic_ball_entity", () -> EntityType.Builder.of(GenericBallEntity::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).clientTrackingRange(4).updateInterval(1).build("generic_ball_entity"));
    @Translation(type=Translation.Type.ENTITY, comments={"Generic Arrow Entity"})
    public static DeferredHolder<EntityType<?>, EntityType<GenericArrowEntity>> GENERIC_ARROW_ENTITY = REGISTRY.register("generic_arrow_entity", () -> EntityType.Builder.of(GenericArrowEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(1).build("generic_arrow_entity"));
    @Translation(type=Translation.Type.ENTITY, comments={"Hunter Hound"})
    public static DeferredHolder<EntityType<?>, EntityType<HoundEntity>> HUNTER_HOUND = REGISTRY.register("hunter_hound", () -> EntityType.Builder.of(HoundEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 0.85f).clientTrackingRange(64).updateInterval(1).build("hunter_hound"));
    @Translation(type=Translation.Type.ENTITY, comments={"Hunter Griffin"})
    public static DeferredHolder<EntityType<?>, EntityType<GriffinEntity>> HUNTER_GRIFFIN = REGISTRY.register("hunter_griffin", () -> EntityType.Builder.of(GriffinEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 0.85f).clientTrackingRange(64).updateInterval(1).build("hunter_griffin"));
    @Translation(type=Translation.Type.ENTITY, comments={"Hunter Spearman"})
    public static DeferredHolder<EntityType<?>, EntityType<SpearmanEntity>> HUNTER_SPEARMAN = REGISTRY.register("hunter_spearman", () -> EntityType.Builder.of(SpearmanEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(64).updateInterval(1).build("hunter_spearman"));
    @Translation(type=Translation.Type.ENTITY, comments={"Hunter Knight"})
    public static DeferredHolder<EntityType<?>, EntityType<KnightEntity>> HUNTER_KNIGHT = REGISTRY.register("hunter_knight", () -> EntityType.Builder.of(KnightEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.5f, 3.0f).clientTrackingRange(64).updateInterval(1).build("hunter_knight"));
    @Translation(type=Translation.Type.ENTITY, comments={"Hunter Ambusher"})
    public static DeferredHolder<EntityType<?>, EntityType<AmbusherEntity>> HUNTER_AMBUSHER = REGISTRY.register("hunter_ambusher", () -> EntityType.Builder.of(AmbusherEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.8f, 2.5f).clientTrackingRange(64).updateInterval(1).build("hunter_ambusher"));
    @Translation(type=Translation.Type.ENTITY, comments={"Hunter Leader"})
    public static DeferredHolder<EntityType<?>, EntityType<LeaderEntity>> HUNTER_LEADER = REGISTRY.register("hunter_leader", () -> EntityType.Builder.of(LeaderEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(64).updateInterval(1).build("hunter_leader"));

    @SubscribeEvent
    public static void attributeCreationEvent(EntityAttributeCreationEvent event) {
        event.put((EntityType)DRAGON.value(), LivingEntity.createLivingAttributes().build());
        event.put((EntityType)HUNTER_HOUND.value(), DSEntities.hunterAttributes().build());
        event.put((EntityType)HUNTER_SPEARMAN.value(), DSEntities.hunterAttributes().build());
        event.put((EntityType)HUNTER_KNIGHT.value(), DSEntities.hunterAttributes().build());
        event.put((EntityType)HUNTER_AMBUSHER.value(), DSEntities.hunterAttributes().build());
        event.put((EntityType)HUNTER_GRIFFIN.value(), DSEntities.hunterAttributes().add(Attributes.FLYING_SPEED).build());
        event.put((EntityType)HUNTER_LEADER.value(), DSEntities.hunterAttributes().build());
    }

    private static AttributeSupplier.Builder hunterAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE);
    }

    @SubscribeEvent
    public static void registerSpawn(RegisterSpawnPlacementsEvent event) {
        SpawnPlacements.SpawnPredicate predicate = (entity, level, spawnType, position, random) -> level.canSeeSky(position) && level.getBlockState(position.below()).isSolid();
        event.register((EntityType)HUNTER_SPEARMAN.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)HUNTER_KNIGHT.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)HUNTER_AMBUSHER.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)HUNTER_HOUND.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)HUNTER_GRIFFIN.value(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }
}

