/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.level.Level;

public class DSDamageTypes {
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s died to anti-dragon weaponry."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s was slain by %s using anti-dragon weaponry."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Anti-Dragon"})})
    public static final ResourceKey<DamageType> ANTI_DRAGON = DSDamageTypes.key("anti_dragon");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s was incinerated by fire breath."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s burnt to a crisp by %s's fire breath."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Fire Breath"})})
    public static final ResourceKey<DamageType> FIRE_BREATH = DSDamageTypes.key("fire_breath");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s succumbed to searing burns."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s succumbed to searing burns whilst fighting %s."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Burn"})})
    public static final ResourceKey<DamageType> BURN = DSDamageTypes.key("burn");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s was crushed."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s was crushed (probably by accident) by %s."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Crushed"})})
    public static final ResourceKey<DamageType> CRUSHED = DSDamageTypes.key("crushed");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s dried out."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Dehydration"})})
    public static final ResourceKey<DamageType> DEHYDRATION = DSDamageTypes.key("dehydration");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s was struck by a ball of lightning."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s was struck by a ball of lightning summoned by %s."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Ball Lightning"})})
    public static final ResourceKey<DamageType> BALL_LIGHTNING = DSDamageTypes.key("ball_lightning");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s succumbed to the breath weapon of a dragon."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s succumbed to the breath weapon of %s."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Dragon Breath"})})
    public static final ResourceKey<DamageType> DRAGON_BREATH = DSDamageTypes.key("dragon_breath");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s was poisoned by a toxic breath."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s was poisoned by %s's toxic breath."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Toxic Breath"})})
    public static final ResourceKey<DamageType> FOREST_BREATH = DSDamageTypes.key("forest_breath");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s had their life force drained."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s had their life force drained by %s."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Drain"})})
    public static final ResourceKey<DamageType> DRAIN = DSDamageTypes.key("drain");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s couldn't handle a light rain."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s couldn't handle a light rain whilst fighting %s."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Rain Burn"})})
    public static final ResourceKey<DamageType> RAIN_BURN = DSDamageTypes.key("rain_burn");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s was zapped by lightning breath."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s was zapped by %s's lightning breath."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Lightning Breath"})})
    public static final ResourceKey<DamageType> LIGHTNING_BREATH = DSDamageTypes.key("lightning_breath");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s was burned by water."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Water Burn"})})
    public static final ResourceKey<DamageType> WATER_BURN = DSDamageTypes.key("water_burn");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s was impaled by plant spikes."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s was impaled by %s's plant spikes."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Spike"})})
    public static final ResourceKey<DamageType> SPIKE = DSDamageTypes.key("spike");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s was electrocuted."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s was electrocuted by %s."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Electric"})})
    public static final ResourceKey<DamageType> ELECTRIC = DSDamageTypes.key("electric");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s got dusted."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s was dusted by %s."}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Blast Dust"})})
    public static final ResourceKey<DamageType> BLAST_DUST = DSDamageTypes.key("blast_dust");
    @Translation.Translations(value={@Translation(type=Translation.Type.DEATH, comments={"%s fell to their own bloodlust."}), @Translation(type=Translation.Type.DEATH_PLAYER, comments={"%s was killed by %s's curse"}), @Translation(type=Translation.Type.DAMAGE_TYPE, comments={"Mirror Curse"})})
    public static final ResourceKey<DamageType> MIRROR_CURSE = DSDamageTypes.key("mirror_curse");

    public static Holder<DamageType> get(Level level, ResourceKey<DamageType> damageType) {
        return level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(damageType);
    }

    public static void registerDamageTypes(BootstrapContext<DamageType> context) {
        DSDamageTypes.register(context, ANTI_DRAGON);
        DSDamageTypes.register(context, FIRE_BREATH);
        DSDamageTypes.register(context, BURN);
        DSDamageTypes.register(context, CRUSHED);
        DSDamageTypes.register(context, DEHYDRATION);
        DSDamageTypes.register(context, BALL_LIGHTNING);
        DSDamageTypes.register(context, DRAGON_BREATH);
        DSDamageTypes.register(context, FOREST_BREATH);
        DSDamageTypes.register(context, DRAIN);
        DSDamageTypes.register(context, RAIN_BURN);
        DSDamageTypes.register(context, LIGHTNING_BREATH);
        DSDamageTypes.register(context, WATER_BURN);
        DSDamageTypes.register(context, SPIKE);
        DSDamageTypes.register(context, ELECTRIC);
        DSDamageTypes.register(context, BLAST_DUST);
        DSDamageTypes.register(context, MIRROR_CURSE);
    }

    private static void register(BootstrapContext<DamageType> context, ResourceKey<DamageType> damageType) {
        context.register(damageType, (Object)DSDamageTypes.type(damageType.location().getPath()));
    }

    private static DamageType type(String messageId) {
        return new DamageType("dragonsurvival." + messageId, DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER, 0.1f, DamageEffects.HURT, DeathMessageType.DEFAULT);
    }

    private static ResourceKey<DamageType> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)name));
    }
}

