/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.player;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MovementData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncDragonMovement(int playerId, boolean isFirstPerson, boolean bite, boolean isFreeLook, Vec3 movement) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncDragonMovement> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("sync_dragon_movement"));
    public static final StreamCodec<FriendlyByteBuf, SyncDragonMovement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncDragonMovement::playerId, (StreamCodec)ByteBufCodecs.BOOL, SyncDragonMovement::isFirstPerson, (StreamCodec)ByteBufCodecs.BOOL, SyncDragonMovement::bite, (StreamCodec)ByteBufCodecs.BOOL, SyncDragonMovement::isFreeLook, MiscCodecs.VEC3_STREAM_CODEC, SyncDragonMovement::movement, SyncDragonMovement::new);

    public static void handleClient(SyncDragonMovement packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player;
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp) != DragonSurvival.PROXY.getLocalPlayer()) {
                SyncDragonMovement.handle(packet, player);
            }
        });
    }

    public static void handleServer(SyncDragonMovement packet, IPayloadContext context) {
        context.enqueueWork(() -> SyncDragonMovement.handle(packet, context.player())).thenRun(() -> PacketDistributor.sendToPlayersTrackingEntity((Entity)context.player(), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    private static void handle(SyncDragonMovement packet, Player player) {
        MovementData data = MovementData.getData((Entity)player);
        data.setFirstPerson(packet.isFirstPerson());
        data.setBite(packet.bite());
        data.setFreeLook(packet.isFreeLook());
        data.setDesiredMoveVec(packet.movement());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

