/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.magic;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.network.animation.StopAbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.network.sound.StopTickingSound;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncStopCast(int playerId, boolean forceWasApplyingEffects) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncStopCast> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("sync_stop_cast"));
    public static final StreamCodec<FriendlyByteBuf, SyncStopCast> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncStopCast::playerId, (StreamCodec)ByteBufCodecs.BOOL, SyncStopCast::forceWasApplyingEffects, SyncStopCast::new);

    public static void handleClient(SyncStopCast packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                MagicData magic = MagicData.getData(player);
                if (packet.forceWasApplyingEffects()) {
                    magic.stopCasting(player, magic.getCurrentlyCasting(), true);
                } else {
                    magic.stopCasting(player);
                }
            }
        });
    }

    public static void handleServer(SyncStopCast packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                MagicData data = MagicData.getData(player);
                DragonAbilityInstance currentlyCasting = data.getCurrentlyCasting();
                if (currentlyCasting == null) {
                    return;
                }
                PacketDistributor.sendToPlayersTrackingEntity((Entity)player, (CustomPacketPayload)new StopTickingSound(currentlyCasting.location().withSuffix(player.getStringUUID())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                if (!currentlyCasting.isApplyingEffects() || currentlyCasting.isApplyingEffects() && !currentlyCasting.hasEndAnimation()) {
                    PacketDistributor.sendToPlayersTrackingEntity((Entity)player, (CustomPacketPayload)new StopAbilityAnimation(player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                data.stopCasting(player);
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

