/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.flight;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncDeltaMovement(int playerId, Vec3 movement) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncDeltaMovement> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("sync_delta_movement"));
    public static final StreamCodec<FriendlyByteBuf, SyncDeltaMovement> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncDeltaMovement::playerId, MiscCodecs.VEC3_STREAM_CODEC, SyncDeltaMovement::movement, SyncDeltaMovement::new);

    public static void handleClient(SyncDeltaMovement packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player;
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player && (player = (Player)patt0$temp) != DragonSurvival.PROXY.getLocalPlayer()) {
                player.setDeltaMovement(packet.movement());
            }
        });
    }

    public static void handleServer(SyncDeltaMovement packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                player.setDeltaMovement(packet.movement());
            }
        }).thenRun(() -> PacketDistributor.sendToPlayersTrackingEntity((Entity)context.player(), (CustomPacketPayload)new SyncDeltaMovement(context.player().getId(), packet.movement()), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

