/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.flight;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SpinDurationAndCooldown(int playerId, int duration, int cooldown) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SpinDurationAndCooldown> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("spin_duration_and_cooldown"));
    public static final StreamCodec<FriendlyByteBuf, SpinDurationAndCooldown> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SpinDurationAndCooldown::playerId, (StreamCodec)ByteBufCodecs.INT, SpinDurationAndCooldown::duration, (StreamCodec)ByteBufCodecs.INT, SpinDurationAndCooldown::cooldown, SpinDurationAndCooldown::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleClient(SpinDurationAndCooldown packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                FlightData spin = FlightData.getData(player);
                spin.cooldown = packet.cooldown();
                spin.duration = packet.duration();
            }
        });
    }

    public static void handleServer(SpinDurationAndCooldown packet, IPayloadContext context) {
        Player sender = context.player();
        context.enqueueWork(() -> {
            FlightData spin = FlightData.getData(sender);
            spin.cooldown = packet.cooldown();
            spin.duration = packet.duration();
        }).thenRun(() -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)sender, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }
}

