/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.claw;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncDragonClawRender(int playerId, boolean shouldRender) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncDragonClawRender> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("sync_dragon_claw_render"));
    public static final StreamCodec<FriendlyByteBuf, SyncDragonClawRender> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncDragonClawRender::playerId, (StreamCodec)ByteBufCodecs.BOOL, SyncDragonClawRender::shouldRender, SyncDragonClawRender::new);

    public static void handleClient(SyncDragonClawRender packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                ClawInventoryData.getData((Player)player).shouldRenderClaws = packet.shouldRender();
            }
        });
    }

    public static void handleServer(SyncDragonClawRender packet, IPayloadContext context) {
        if (ServerConfig.syncClawRender.booleanValue()) {
            context.enqueueWork(() -> {
                Entity patt0$temp = context.player().level().getEntity(packet.playerId());
                if (patt0$temp instanceof Player) {
                    Player player = (Player)patt0$temp;
                    ClawInventoryData.getData((Player)player).shouldRenderClaws = packet.shouldRender();
                }
            }).thenRun(() -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)context.player(), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

