/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.animation;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AnimationType;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.CompoundAbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.SimpleAbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SyncAbilityAnimation(int playerId, AnimationType animationType, Either<CompoundAbilityAnimation, SimpleAbilityAnimation> animation) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncAbilityAnimation> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("sync_ability_animation"));
    public static final StreamCodec<FriendlyByteBuf, SyncAbilityAnimation> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncAbilityAnimation::playerId, (StreamCodec)ByteBufCodecs.STRING_UTF8.map(AnimationType::valueOf, Enum::name), SyncAbilityAnimation::animationType, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.either(CompoundAbilityAnimation.CODEC, SimpleAbilityAnimation.CODEC)), SyncAbilityAnimation::animation, SyncAbilityAnimation::new);

    public static void handleClient(SyncAbilityAnimation packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity = context.player().level().getEntity(packet.playerId());
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            DragonEntity dragon = ClientDragonRenderer.getDragon(player);
            if (dragon == null) {
                return;
            }
            AbilityAnimation abilityAnimation = (AbilityAnimation)packet.animation.map(simple -> simple, compound -> compound);
            dragon.setCurrentAbilityAnimation((Pair<AbilityAnimation, AnimationType>)new Pair((Object)abilityAnimation, (Object)packet.animationType));
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

