/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins.client;

import by.dragonsurvivalteam.dragonsurvival.mixins.client.AbstractContainerScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.EffectRenderingInventoryScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.ClientEffectProvider;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EffectRenderingInventoryScreen.class})
public class EffectRenderingInventoryScreenMixin {
    @Unique
    private List<ClientEffectProvider> dragonSurvival$providers = List.of();
    @Unique
    private final List<Rect2i> dragonSurvival$areasBlockedByModifierUIForJEI = new ArrayList<Rect2i>();

    @Inject(method={"renderEffects"}, at={@At(value="HEAD")})
    private void dragonSurvival$storeProviders(GuiGraphics graphics, int mouseX, int mouseY, CallbackInfo callback) {
        this.dragonSurvival$providers = ClientEffectProvider.getProviders(true);
        this.dragonSurvival$areasBlockedByModifierUIForJEI.clear();
    }

    @ModifyExpressionValue(method={"renderEffects"}, at={@At(value="INVOKE", target="Ljava/util/Collection;size()I")})
    private int dragonSurvival$adjustRenderedEffectsSize(int original) {
        return original + this.dragonSurvival$providers.size();
    }

    @Inject(method={"renderEffects"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/client/ClientHooks;onScreenPotionSize(Lnet/minecraft/client/gui/screens/Screen;IZI)Lnet/neoforged/neoforge/client/event/ScreenEvent$RenderInventoryMobEffects;", shift=At.Shift.BY, by=2)})
    private void dragonSurvival$storeEvent(CallbackInfo callback, @Local ScreenEvent.RenderInventoryMobEffects event, @Share(value="stored_event") LocalRef<ScreenEvent.RenderInventoryMobEffects> storedEvent) {
        storedEvent.set((Object)event);
    }

    @Unique
    private void dragonSurvival$renderAbilityBackgroundsAndIcons(GuiGraphics graphics, int renderX, int yOffset, int initialYOffset, List<ClientEffectProvider> providers, boolean isCompact) {
        EffectRenderingInventoryScreen self = (EffectRenderingInventoryScreen)this;
        int topPos = ((AbstractContainerScreenAccessor)self).dragonSurvival$getTopPos() + initialYOffset;
        int width = isCompact ? 32 : 120;
        for (ClientEffectProvider provider : providers) {
            this.dragonSurvival$areasBlockedByModifierUIForJEI.add(new Rect2i(renderX, topPos, width, 32));
            graphics.blitSprite(isCompact ? EffectRenderingInventoryScreenAccessor.dragonSurvival$getEffectBackgroundSmallSprite() : EffectRenderingInventoryScreenAccessor.dragonSurvival$getEffectBackgroundLargeSprite(), renderX, topPos, width, 32);
            graphics.blit(provider.clientData().texture(), renderX + (isCompact ? 6 : 7), topPos + 7, 0, 0.0f, 0.0f, 18, 18, 18, 18);
            topPos += yOffset;
        }
    }

    @Unique
    private void dragonSurvival$renderAbilityLabels(GuiGraphics graphics, int renderX, int yOffset, int initialYOffset, List<ClientEffectProvider> providers) {
        EffectRenderingInventoryScreen self = (EffectRenderingInventoryScreen)this;
        int topPos = ((AbstractContainerScreenAccessor)self).dragonSurvival$getTopPos() + initialYOffset;
        for (ClientEffectProvider provider : providers) {
            graphics.drawString(((ScreenAccessor)self).dragonSurvival$getFont(), provider.clientData().name(), renderX + 10 + 18, topPos + 6, 0xFFFFFF);
            Component duration = EffectRenderingInventoryScreenMixin.dragonSurvival$formatDuration(provider, Minecraft.getInstance().level.tickRateManager().tickrate());
            graphics.drawString(((ScreenAccessor)self).dragonSurvival$getFont(), duration, renderX + 10 + 18, topPos + 6 + 10, 0x7F7F7F);
            topPos += yOffset;
        }
    }

    @Unique
    private static Component dragonSurvival$formatDuration(ClientEffectProvider effect, float ticksPerSecond) {
        if (effect.isInfiniteDuration()) {
            return Component.translatable((String)LangKey.DURATION, (Object[])new Object[]{DSColors.dynamicValue(Component.translatable((String)"effect.duration.infinite"))});
        }
        int duration = Mth.floor((float)effect.currentDuration());
        return Component.translatable((String)LangKey.DURATION, (Object[])new Object[]{DSColors.dynamicValue(StringUtil.formatTickDuration((int)duration, (float)ticksPerSecond))});
    }

    @Inject(method={"renderEffects"}, at={@At(value="TAIL")})
    private void dragonSurvival$renderAbilityEffects(GuiGraphics graphics, int mouseX, int mouseY, CallbackInfo callback, @Share(value="stored_event") LocalRef<ScreenEvent.RenderInventoryMobEffects> storedEvent) {
        EffectRenderingInventoryScreen self = (EffectRenderingInventoryScreen)this;
        int offset = ((AbstractContainerScreenAccessor)self).dragonSurvival$getLeftPos() + ((AbstractContainerScreenAccessor)self).dragonSurvival$imageWidth() + 2;
        int width = self.width;
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        if (!this.dragonSurvival$providers.isEmpty() && width >= 32) {
            boolean isCompact = width >= 120;
            ScreenEvent.RenderInventoryMobEffects event = (ScreenEvent.RenderInventoryMobEffects)storedEvent.get();
            if (event == null) {
                event = ClientHooks.onScreenPotionSize((Screen)self, (int)width, (boolean)isCompact, (int)offset);
            }
            if (event.isCanceled()) {
                return;
            }
            isCompact = event.isCompact();
            offset = event.getHorizontalOffset();
            Collection mobEffects = player.getActiveEffects();
            int totalElementsToRender = mobEffects.size() + this.dragonSurvival$providers.size();
            int yOffset = totalElementsToRender > 5 ? 132 / (totalElementsToRender - 1) : 33;
            int renderedElements = mobEffects.stream().filter(ClientHooks::shouldRenderEffect).sorted().toList().size();
            int initialYOffset = yOffset * renderedElements;
            this.dragonSurvival$renderAbilityBackgroundsAndIcons(graphics, offset, yOffset, initialYOffset, this.dragonSurvival$providers, isCompact);
            if (!isCompact) {
                this.dragonSurvival$renderAbilityLabels(graphics, offset, yOffset, initialYOffset, this.dragonSurvival$providers);
            }
            if (mouseX >= offset && mouseX <= offset + (isCompact ? 32 : 120)) {
                int topPos = ((AbstractContainerScreenAccessor)self).dragonSurvival$getTopPos() + initialYOffset;
                ClientEffectProvider hovered = null;
                for (ClientEffectProvider provider : this.dragonSurvival$providers) {
                    if (mouseY >= topPos && mouseY <= topPos + yOffset) {
                        hovered = provider;
                    }
                    topPos += yOffset;
                }
                if (hovered != null) {
                    MutableComponent tooltip = Component.empty();
                    tooltip.append(hovered.clientData().name());
                    if (Minecraft.getInstance().options.advancedItemTooltips) {
                        tooltip.append((Component)Component.literal((String)("\n" + hovered.clientData().id().toString())).withStyle(ChatFormatting.DARK_GRAY));
                    }
                    if (hovered.clientData().effectSource().getContents() != PlainTextContents.EMPTY) {
                        tooltip.append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)LangKey.APPLIED_BY, (Object[])new Object[]{DSColors.dynamicValue(hovered.clientData().effectSource())}));
                    }
                    tooltip.append((Component)Component.literal((String)"\n")).append(EffectRenderingInventoryScreenMixin.dragonSurvival$formatDuration(hovered, Minecraft.getInstance().level.tickRateManager().tickrate()));
                    Component description = hovered.getDescription();
                    if (description.getContents() != PlainTextContents.EMPTY) {
                        tooltip.append((Component)Component.literal((String)"\n\n")).append(description);
                    }
                    Font font = ((ScreenAccessor)self).dragonSurvival$getFont();
                    graphics.renderTooltip(font, font.split((FormattedText)tooltip, 170), mouseX, mouseY);
                }
            }
        }
    }
}

