/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins.client;

import by.dragonsurvivalteam.dragonsurvival.mixins.client.LocalPlayerAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={Camera.class})
public abstract class CameraMixin {
    @Shadow
    @Final
    private Vector3f up;
    @Shadow
    private Vec3 position;
    @Shadow
    private Entity entity;

    @Inject(method={"getMaxZoom"}, at={@At(value="HEAD")})
    private void dragonSurvival$moveCameraPositionUpWhenInVisualBlockWithNoCollision(float maxZoom, CallbackInfoReturnable<Float> callback) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (this.entity != player) {
            return;
        }
        if (((LocalPlayerAccessor)player).dragonSurvival$suffocatesAt(BlockPos.containing((Position)player.position()))) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            float xOffset;
            float scale = Math.min(1.0f, player.getScale());
            float cameraOffset = 0.1f * scale;
            float f = i == 0 ? 0.0f : (i == 1 ? cameraOffset : (xOffset = i == 2 ? -cameraOffset : 0.0f));
            float zOffset = i == 0 ? 0.0f : (i == 3 ? cameraOffset : (i == 4 ? -cameraOffset : 0.0f));
            Vec3 offsetStart = this.position.subtract((double)xOffset, (double)cameraOffset, (double)zOffset);
            Vec3 up = offsetStart.add(new Vec3(this.up).scale((double)maxZoom));
            BlockHitResult visualHit = Minecraft.getInstance().level.clip(new ClipContext(offsetStart, up, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, this.entity));
            BlockHitResult collisionHit = Minecraft.getInstance().level.clip(new ClipContext(offsetStart, up, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.entity));
            if (visualHit.getLocation() == collisionHit.getLocation() || visualHit.getType() != HitResult.Type.BLOCK || !visualHit.isInside()) continue;
            VoxelShape shape = Minecraft.getInstance().level.getBlockState(visualHit.getBlockPos()).getVisualShape((BlockGetter)Minecraft.getInstance().level, visualHit.getBlockPos(), CollisionContext.empty());
            double highestY = shape.max(Direction.Axis.Y);
            this.position = new Vec3(this.position.x, (double)visualHit.getBlockPos().getY() + highestY + (double)cameraOffset, this.position.z);
            return;
        }
    }

    @ModifyVariable(method={"getMaxZoom"}, at=@At(value="STORE"), ordinal=5)
    private float dragonSurvival$modifyDistance(float distance) {
        float scale = Minecraft.getInstance().player.getScale();
        if (scale < 1.0f) {
            return distance * scale;
        }
        return distance;
    }

    @ModifyArgs(method={"getMaxZoom"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;add(DDD)Lnet/minecraft/world/phys/Vec3;"))
    private void dragonSurvival$adjustCameraPosition(Args args) {
        float scale = Math.min(1.0f, Minecraft.getInstance().player.getScale());
        args.set(0, (Object)((Double)args.get(0) * (double)scale));
        args.set(1, (Object)((Double)args.get(1) * (double)scale));
        args.set(2, (Object)((Double)args.get(2) * (double)scale));
    }
}

