/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonFoodHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.EnchantmentEffectHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.EffectModifications;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.HunterData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SummonedEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SwimData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger.OnTargetKilled;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    protected boolean jumping;
    @Shadow
    protected ItemStack useItem;

    @Shadow
    public abstract boolean onClimbable();

    @Shadow
    protected abstract Vec3 handleOnClimbable(Vec3 var1);

    @Shadow
    protected abstract float getFrictionInfluencedSpeed(float var1);

    @Shadow
    public abstract void calculateEntityAnimation(boolean var1);

    @Shadow
    public abstract boolean shouldDiscardFriction();

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    public LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"die"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;dropAllDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)V", shift=At.Shift.AFTER)})
    private void dragonSurvival$triggerOnTargetKilled(DamageSource source, CallbackInfo callback) {
        OnTargetKilled.trigger((LivingEntity)this, source);
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;moveRelative(FLnet/minecraft/world/phys/Vec3;)V", ordinal=1))
    private float dragonSurvival$modifyLavaSwimSpeed(float original) {
        return (float)((double)original * this.getAttributeValue(DSAttributes.LAVA_SWIM_SPEED));
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/core/Holder;)Z", ordinal=2)})
    private boolean dragonSurvival$disableLevitationWhenTrapped(boolean hasLevitation) {
        if (this.hasEffect(DSEffects.TRAPPED)) {
            return false;
        }
        return hasLevitation;
    }

    @ModifyReturnValue(method={"canBeSeenByAnyone"}, at={@At(value="RETURN")})
    private boolean dragonSurvival$hasMaxHunterStacks(boolean canBeSeen) {
        if (!canBeSeen) {
            return false;
        }
        return !HunterData.hasMaxHunterStacks((LivingEntity)this);
    }

    @ModifyExpressionValue(method={"getPassengerRidingPosition"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getDimensions(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/entity/EntityDimensions;")})
    public EntityDimensions dragonSurvival$useCorrectDimensionsForPassengerRidingCalculation(EntityDimensions original) {
        LivingEntity self = (LivingEntity)this;
        if (DragonStateProvider.isDragon((Entity)self) && self instanceof Player) {
            Player player = (Player)self;
            return DragonSizeHandler.calculateDimensions(DragonStateProvider.getData(player), player, DragonSizeHandler.getOverridePose(player));
        }
        return original;
    }

    @Unique
    private int dragonSurvival$getHumanOrDragonUseDuration(int original) {
        Player player;
        DragonStateHandler handler;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (handler = DragonStateProvider.getData(player = (Player)livingEntityMixin)) != null && handler.isDragon()) {
            return DragonFoodHandler.getUseDuration(this.useItem, player, original);
        }
        return original;
    }

    @ModifyExpressionValue(method={"shouldTriggerItemUseEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration(Lnet/minecraft/world/entity/LivingEntity;)I")})
    private int replaceUseDurationInShouldTriggerItemUseEffects(int original) {
        return this.dragonSurvival$getHumanOrDragonUseDuration(original);
    }

    @ModifyExpressionValue(method={"onSyncedDataUpdated"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration(Lnet/minecraft/world/entity/LivingEntity;)I")})
    private int replaceUseDurationInSyncedDataUpdated(int original) {
        return this.dragonSurvival$getHumanOrDragonUseDuration(original);
    }

    @ModifyExpressionValue(method={"triggerItemUseEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseAnimation()Lnet/minecraft/world/item/UseAnim;")})
    private UseAnim dragonSurvival$replaceEatAndDrinkAnimation(UseAnim original, ItemStack stack, int amount) {
        Player player;
        DragonStateHandler handler;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && (handler = DragonStateProvider.getData(player = (Player)livingEntityMixin)).isDragon()) {
            return DragonFoodHandler.isEdible(player, stack) && original != UseAnim.DRINK ? UseAnim.EAT : original;
        }
        return original;
    }

    @ModifyVariable(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private MobEffectInstance dragonSurvival$modifyEffect(MobEffectInstance instance, @Local(argsOnly=true) Entity applier) {
        EffectModifications data;
        LivingEntity self = (LivingEntity)this;
        MobEffectInstance newInstance = instance;
        if (self instanceof Player) {
            Player affected = (Player)self;
            newInstance = EnchantmentEffectHandler.modifyEffect(affected, instance, applier);
        }
        if ((data = (EffectModifications)self.getExistingData(DSDataAttachments.EFFECT_MODIFICATIONS).orElse(null)) != null) {
            newInstance = data.modifyEffect(newInstance);
        }
        return newInstance;
    }

    @ModifyReturnValue(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="RETURN")})
    private boolean dragonSurvival$checkSummonRelationship(boolean canAttack, @Local(argsOnly=true, ordinal=0) LivingEntity target) {
        if (!canAttack) {
            return false;
        }
        return !SummonedEntities.hasSummonRelationship(this, (Entity)target);
    }

    @Inject(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;", shift=At.Shift.BY, by=2)}, cancellable=true)
    private void dragonSurvival$handleDragonSwimming(Vec3 travelVector, CallbackInfo callback, @Local double gravity, @Local FluidState fluidState) {
        boolean isFalling;
        boolean isLavaSwimming;
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntityMixin;
        DragonStateHandler data = DragonStateProvider.getData(player);
        if (!data.isDragon()) {
            return;
        }
        SwimData swimData = SwimData.getData(player);
        boolean bl = isLavaSwimming = swimData.canSwimIn((ResourceKey<FluidType>)NeoForgeMod.LAVA_TYPE.getKey()) && this.isInLava();
        if (!isLavaSwimming && !this.isInWater() || !player.isAffectedByFluids() || player.canStandOnFluid(fluidState)) {
            return;
        }
        boolean isCrouching = player.isCrouching();
        boolean bl2 = isFalling = this.getDeltaMovement().y <= 0.0;
        if (this.jumping || isCrouching || travelVector.horizontalDistance() > 0.05) {
            float lookY = (float)this.getLookAngle().y;
            float minSpeed = 0.04f;
            float maxSpeed = 0.12f;
            float yModifier = minSpeed + (maxSpeed - minSpeed) * Mth.abs((float)Math.clamp(lookY, -1.0f, 1.0f));
            if (this.isSprinting()) {
                yModifier *= 1.2f;
            }
            if (this.jumping || isCrouching || (double)Math.abs(lookY) > 0.1) {
                if (this.jumping && lookY < 0.0f || isCrouching && lookY > 0.0f) {
                    lookY *= -1.0f;
                    yModifier = minSpeed;
                }
                Vec3 deltaMovement = this.getDeltaMovement();
                this.setDeltaMovement(deltaMovement.add(0.0, ((double)lookY - deltaMovement.y) * (double)Mth.abs((float)yModifier), 0.0));
            }
        }
        if (isLavaSwimming) {
            double oldY = this.getY();
            float speedModifier = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
            float swimSpeed = 0.05f;
            float swimSpeedModifier = 1.0f;
            if (!this.onGround()) {
                swimSpeedModifier *= 0.5f;
            }
            if (swimSpeedModifier > 0.0f) {
                speedModifier += (0.54600006f - speedModifier) * swimSpeedModifier;
                swimSpeed += (player.getSpeed() - swimSpeed) * swimSpeedModifier;
            }
            if (player.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                speedModifier = 0.96f;
            }
            this.moveRelative(swimSpeed *= (float)player.getAttributeValue(DSAttributes.LAVA_SWIM_SPEED), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            Vec3 newMovement = this.getDeltaMovement();
            if (this.horizontalCollision && player.onClimbable()) {
                newMovement = new Vec3(newMovement.x, 0.2, newMovement.z);
            }
            this.setDeltaMovement(newMovement.multiply((double)speedModifier, 0.8, (double)speedModifier));
            Vec3 adjustedMovement = player.getFluidFallingAdjustedMovement(gravity, isFalling, this.getDeltaMovement());
            this.setDeltaMovement(adjustedMovement);
            if (this.horizontalCollision && this.isFree(adjustedMovement.x, adjustedMovement.y + 0.6 - this.getY() + oldY, adjustedMovement.z)) {
                this.setDeltaMovement(adjustedMovement.x, 0.3, adjustedMovement.z);
            }
            player.calculateEntityAnimation(false);
            callback.cancel();
        }
    }

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract double getAttributeValue(Holder<Attribute> var1);

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    @Shadow
    protected abstract float getWaterSlowDown();
}

