/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ItemData;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements IEntityWithComplexSpawn {
    public ItemEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void writeSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
        this.getExistingData((Supplier)DSDataAttachments.ITEM).ifPresentOrElse(data -> buffer.writeBoolean(data.isFireImmune), () -> buffer.writeBoolean(false));
    }

    public void readSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
        if (!buffer.readBoolean()) {
            return;
        }
        ((ItemData)this.getData(DSDataAttachments.ITEM)).isFireImmune = true;
    }

    @ModifyReturnValue(method={"fireImmune"}, at={@At(value="RETURN")})
    private boolean dragonSurvival$makeFireImmune(boolean isFireImmune) {
        return isFireImmune || this.getExistingData((Supplier)DSDataAttachments.ITEM).map(data -> data.isFireImmune).orElse(false) != false;
    }
}

