/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.HunterHandler;
import by.dragonsurvivalteam.dragonsurvival.compat.Compat;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DamageModifications;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.HunterData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MovementData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SummonedEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SwimData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSEntityTypeTags;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.DragonRidingHandler;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @ModifyReturnValue(method={"getPassengerAttachmentPoint"}, at={@At(value="RETURN")})
    protected Vec3 dragonSurvival$modifyPassengerAttachmentPoint(Vec3 original, @Local(argsOnly=true, index=0) Entity entity) {
        Player player;
        Player passenger;
        Entity mount = (Entity)this;
        if (!(entity instanceof Player) || !this.hasPassenger((Entity)(passenger = (Player)entity))) {
            return original;
        }
        if (mount instanceof Player && DragonStateProvider.isDragon((Entity)(player = (Player)mount))) {
            DragonStateHandler handler = DragonStateProvider.getData(player);
            MovementData movement = MovementData.getData((Entity)player);
            if (((DragonBody)handler.body().value()).mountingOffsets().isEmpty()) {
                return original;
            }
            Vec3 offset = DragonStateProvider.isDragon((Entity)passenger) ? ((DragonBody)handler.body().value()).mountingOffsets().get().dragonOffset() : ((DragonBody)handler.body().value()).mountingOffsets().get().humanOffset();
            Vec3 offsetPerScaleAboveOne = ((DragonBody)handler.body().value()).mountingOffsets().get().scale();
            float scale = player.getScale();
            offset = offset.add(offsetPerScaleAboveOne.scale((double)(scale - 1.0f)));
            original = original.add(offset);
            original = original.xRot((float)Math.toRadians((double)movement.prevXRot * 1.5)).zRot(-((float)Math.toRadians(movement.prevZRot * 90.0f)));
            original = original.add(offset).yRot(-((float)Math.toRadians(movement.bodyYawLastFrame)));
            return original;
        }
        if (DragonStateProvider.isDragon((Entity)passenger) && !DragonStateProvider.isDragon(mount)) {
            return original.add(DragonRidingHandler.getMountingOffsetForEntity(mount));
        }
        return original;
    }

    @ModifyReturnValue(method={"getPassengerRidingPosition"}, at={@At(value="RETURN")})
    protected Vec3 dragonSurvival$modifyPassengerRidingPosition(Vec3 original, @Local(argsOnly=true, index=0) Entity entity) {
        Player passenger;
        Entity mount = (Entity)this;
        if (entity instanceof Player && this.hasPassenger((Entity)(passenger = (Player)entity)) && DragonStateProvider.isDragon((Entity)passenger) && !DragonStateProvider.isDragon(mount)) {
            return original.add(DragonRidingHandler.getMountingOffsetForEntity(mount));
        }
        return original;
    }

    @Inject(method={"onPassengerTurned(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void dragonSurvival$onPassengerTurned(Entity entity, CallbackInfo callback) {
        Player vehicle;
        Player passenger;
        block7: {
            block6: {
                if (!(entity instanceof Player)) break block6;
                passenger = (Player)entity;
                Entity entity2 = (Entity)this;
                if (!(entity2 instanceof Player)) break block6;
                vehicle = (Player)entity2;
                if (passenger.level().isClientSide()) break block7;
            }
            return;
        }
        if (!DragonStateProvider.isDragon((Entity)vehicle)) {
            return;
        }
        MovementData vehicleMovement = MovementData.getData((Entity)vehicle);
        if (DragonStateProvider.isDragon((Entity)passenger)) {
            MovementData passengerMovement = MovementData.getData((Entity)passenger);
            float facing = (float)Mth.wrapDegrees((double)((double)passenger.getYRot() - vehicleMovement.bodyYawLastFrame));
            float facingClamped = Mth.clamp((float)facing, (float)-150.0f, (float)150.0f);
            passenger.yRotO += facingClamped - facing + vehicle.yRotO;
            passengerMovement.bodyYaw = vehicleMovement.bodyYawLastFrame;
            passengerMovement.headYaw = -facing;
            passenger.setYRot((float)((double)(passenger.getYRot() + facingClamped - facing) + (vehicleMovement.bodyYawLastFrame - vehicleMovement.bodyYaw)));
        } else {
            float facing = (float)Mth.wrapDegrees((double)((double)passenger.getYRot() - vehicleMovement.bodyYawLastFrame));
            float facingClamped = Mth.clamp((float)facing, (float)-120.0f, (float)120.0f);
            passenger.yRotO += facingClamped - facing + vehicle.yRotO;
            passenger.setYBodyRot((float)((double)(passenger.getYRot() + facingClamped - facing) + (vehicleMovement.bodyYawLastFrame - vehicleMovement.bodyYaw)));
            passenger.setYRot((float)((double)(passenger.getYRot() + facingClamped - facing) + (vehicleMovement.bodyYawLastFrame - vehicleMovement.bodyYaw)));
            passenger.setYHeadRot(passenger.getYRot());
        }
    }

    @ModifyReturnValue(method={"displayFireAnimation()Z"}, at={@At(value="RETURN")})
    private boolean dragonSurvival$hideCaveDragonFireAnimation(boolean displayAnimation) {
        if (!displayAnimation) {
            return false;
        }
        Entity entity = (Entity)this;
        return !entity.fireImmune();
    }

    @Inject(method={"isVisuallyCrawling()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void dragonSurvival$isDragonVisuallyCrawling(CallbackInfoReturnable<Boolean> callback) {
        if (DragonStateProvider.isDragon((Entity)this)) {
            callback.setReturnValue((Object)false);
        }
    }

    @ModifyReturnValue(method={"canRide"}, at={@At(value="RETURN")})
    private boolean dragonSurvival$canRide(boolean canRide, Entity mount) {
        if (!canRide) {
            return false;
        }
        if (ServerConfig.limitedRiding.booleanValue() && DragonStateProvider.isDragon((Entity)this) && !DragonStateProvider.isDragon(mount)) {
            return mount.getType().is(DSEntityTypeTags.VEHICLE_WHITELIST);
        }
        return canRide;
    }

    @ModifyReturnValue(method={"isInvisible"}, at={@At(value="RETURN")})
    private boolean dragonSurvival$enableHunterStacksInvisibility(boolean isInvisible) {
        LivingEntity entity;
        if (isInvisible) {
            return true;
        }
        EntityMixin entityMixin = this;
        if (entityMixin instanceof LivingEntity && HunterData.hasMaxHunterStacks(entity = (LivingEntity)entityMixin)) {
            return HunterHandler.calculateAlpha((Entity)entity) == 0;
        }
        return false;
    }

    @ModifyReturnValue(method={"fireImmune"}, at={@At(value="RETURN")})
    private boolean dragonSurvival$caveDragonFireImmunity(boolean isFireImmune) {
        if (isFireImmune) {
            return true;
        }
        Entity self = (Entity)this;
        return self.getExistingData(DSDataAttachments.DAMAGE_MODIFICATIONS).map(DamageModifications::isFireImmune).orElse(false);
    }

    @Inject(method={"isAlliedTo(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void dragonSurvival$checkSummonRelationship(Entity target, CallbackInfoReturnable<Boolean> callback) {
        if (((Boolean)callback.getReturnValue()).booleanValue()) {
            return;
        }
        Entity self = (Entity)this;
        if (SummonedEntities.hasSummonRelationship(self, target)) {
            callback.setReturnValue((Object)true);
        }
    }

    @ModifyReturnValue(method={"getDeltaMovement"}, at={@At(value="RETURN")})
    private Vec3 dragonSurvival$handleSummonStay(Vec3 deltaMovement) {
        Entity self = (Entity)this;
        if (self.getExistingData(DSDataAttachments.SUMMON).map(data -> data.movementBehaviour == SummonedEntities.MovementBehaviour.STAY).orElse(false).booleanValue()) {
            return Vec3.ZERO;
        }
        return deltaMovement;
    }

    @ModifyReturnValue(method={"getMaxAirSupply"}, at={@At(value="RETURN")})
    private int dragonSurvival$modifyMaxAirSupply(int maxAirSupply) {
        Entity self = (Entity)this;
        if (self instanceof Player) {
            Player player = (Player)self;
            SwimData swimData = SwimData.getData(player);
            int newMaxAirSupply = swimData.getMaxOxygen(player, self.getEyeInFluidType());
            if (newMaxAirSupply == -1) {
                return maxAirSupply;
            }
            return newMaxAirSupply;
        }
        return maxAirSupply;
    }

    @Inject(method={"refreshDimensions"}, at={@At(value="TAIL")})
    private void dragonSurvival$fudgePositionAfterDragonSizeChange(CallbackInfo callback, @Local(ordinal=0) EntityDimensions entitydimensions) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Player) {
            Player player = (Player)entityMixin;
            DragonStateHandler handler = DragonStateProvider.getData(player);
            if (!handler.isDragon() || Compat.hasModelSwap(player)) {
                return;
            }
            if (handler.shouldFudgePosition) {
                DragonSizeHandler.fudgePositionAfterSizeChange((Entity)player, entitydimensions);
            }
            DragonSizeHandler.overridePose(player);
        }
    }

    @ModifyExpressionValue(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity$MovementEmission;emitsSounds()Z")})
    private boolean dragonSurvival$modifyWalkSoundsWhenWalkingUnderwater(boolean original) {
        Entity self = (Entity)this;
        if (DragonStateProvider.isDragon(self) && self instanceof Player) {
            Player player = (Player)self;
            return original && !DragonEntity.isConsideredSwimmingForAnimation(player);
        }
        return original;
    }

    @Shadow
    public abstract double getX();

    @Shadow
    public abstract double getY();

    @Shadow
    public abstract double getZ();

    @Shadow
    public abstract boolean hasPassenger(Entity var1);
}

