/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.structures;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.EndPlatform;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDataMaps;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.PlacedEndPlatforms;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class EndPlatformHandler {
    private static final StructurePlaceSettings SETTINGS = new StructurePlaceSettings().setRotation(Rotation.NONE).setMirror(Mirror.NONE).setIgnoreEntities(false).setKnownShape(true);

    @Nullable
    public static BlockPos getSpawnPoint(Player player) {
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (!handler.isDragon()) {
            return null;
        }
        EndPlatform data = (EndPlatform)handler.species().getData(DSDataMaps.END_PLATFORMS);
        if (data != null) {
            return data.spawnPosition();
        }
        return null;
    }

    public static boolean placePlatform(Player player, ServerLevel level, BlockPos position) {
        DragonStateHandler handler = DragonStateProvider.getData(player);
        if (!handler.isDragon()) {
            return false;
        }
        EndPlatform data = (EndPlatform)handler.species().getData(DSDataMaps.END_PLATFORMS);
        if (data == null) {
            return false;
        }
        ResourceLocation platform = data.structure();
        PlacedEndPlatforms platforms = (PlacedEndPlatforms)level.getData(DSDataAttachments.PLACED_END_PLATFORMS);
        if (platforms.wasPlaced(platform)) {
            EndPlatformHandler.createNormalPlatform(level, position.below());
            return true;
        }
        platforms.addPlatform(platform);
        StructureTemplate template = level.getStructureManager().getOrCreate(platform);
        BlockPos spawnPosition = position.offset(-template.getSize().getX() / 2, -template.getSize().getY() / 2, -template.getSize().getZ() / 2);
        BlockPos.betweenClosedStream((BoundingBox)template.getBoundingBox(SETTINGS, spawnPosition)).forEach(toClear -> level.setBlock(toClear, Blocks.AIR.defaultBlockState(), 3));
        return template.placeInWorld((ServerLevelAccessor)level, spawnPosition, spawnPosition, SETTINGS, level.getRandom(), 18);
    }

    private static void createNormalPlatform(ServerLevel level, BlockPos position) {
        BlockPos.MutableBlockPos mutablePosition = position.mutable();
        for (int z = -2; z <= 2; ++z) {
            for (int x = -2; x <= 2; ++x) {
                for (int y = -1; y < 3; ++y) {
                    Block block;
                    BlockPos.MutableBlockPos currentPosition = mutablePosition.set((Vec3i)position).move(x, y, z);
                    BlockState state = level.getBlockState((BlockPos)currentPosition);
                    Block block2 = block = y == -1 ? Blocks.OBSIDIAN : Blocks.AIR;
                    if (state.is(DSBlockTags.END_PLATFORM_NON_REPLACEABLE) && (block == Blocks.AIR || state.blocksMotion()) || block != Blocks.AIR && state.blocksMotion()) continue;
                    level.setBlock((BlockPos)currentPosition, block.defaultBlockState(), 3);
                }
            }
        }
    }
}

