/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.items.armor;

import by.dragonsurvivalteam.dragonsurvival.common.items.armor.PermanentEnchantmentItem;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEnchantments;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEquipment;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSItemTags;
import by.dragonsurvivalteam.dragonsurvival.util.EnchantmentUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.NotNull;

public class DarkDragonArmorItem
extends ArmorItem
implements PermanentEnchantmentItem {
    @Override
    public ItemEnchantments getDefaultEnchantments() {
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        switch (this.getType()) {
            case HELMET: {
                EnchantmentUtils.set(enchantments, DSEnchantments.BLOOD_SIPHON, 1);
                break;
            }
            case CHESTPLATE: {
                EnchantmentUtils.set(enchantments, DSEnchantments.MURDERERS_CUNNING, 1);
                break;
            }
            case LEGGINGS: {
                EnchantmentUtils.set(enchantments, DSEnchantments.OVERWHELMING_MIGHT, 1);
                break;
            }
            case BOOTS: {
                EnchantmentUtils.set(enchantments, DSEnchantments.DRACONIC_SUPERIORITY, 1);
            }
        }
        EnchantmentUtils.set(enchantments, DSEnchantments.CURSE_OF_OUTLAW, 1);
        return enchantments.toImmutable();
    }

    public DarkDragonArmorItem(ArmorItem.Type pType, Item.Properties pProperties) {
        super(DSEquipment.DARK_DRAGON_ARMOR_MATERIAL, pType, pProperties);
    }

    public boolean canEquip(@NotNull ItemStack stack, @NotNull EquipmentSlot armorType, @NotNull LivingEntity entity) {
        if (!super.canEquip(stack, armorType, entity)) {
            return false;
        }
        for (ItemStack armor : entity.getArmorSlots()) {
            if (armor.isEmpty() || entity.getEquipmentSlotForItem(armor) == armorType || !armor.is(DSItemTags.LIGHT_ARMOR)) continue;
            return false;
        }
        return true;
    }
}

