/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.items;

import by.dragonsurvivalteam.dragonsurvival.client.render.item.RotatingKeyRenderer;
import by.dragonsurvivalteam.dragonsurvival.common.items.TooltipItem;
import by.dragonsurvivalteam.dragonsurvival.registry.data_components.DSDataComponents;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RotatingKeyItem
extends TooltipItem
implements GeoItem {
    public final ResourceLocation texture;
    public final ResourceLocation model;
    private final TagKey<Structure> target;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    public final RawAnimation NO_TARGET = RawAnimation.begin().thenPlay("no_target");
    public final Vector3f fake_target = new Vector3f();
    public Vector3f currentTarget = new Vector3f();
    public Player playerHoldingItem;

    public RotatingKeyItem(Item.Properties properties, ResourceLocation model, ResourceLocation texture, ResourceLocation target) {
        super(properties, null);
        this.target = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)target);
        this.model = model;
        this.texture = texture;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private RotatingKeyRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new RotatingKeyRenderer();
                }
                return this.renderer;
            }
        });
    }

    public double getTick(Object itemStack) {
        return super.getTick(itemStack);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "rotating_key_controller", 10, state -> PlayState.CONTINUE).triggerableAnim("idle", this.IDLE).triggerableAnim("no_target", this.NO_TARGET));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean isSelected) {
        Player player;
        super.inventoryTick(stack, level, entity, slot, isSelected);
        if (!(entity instanceof Player) || (player = (Player)entity).getMainHandItem() != stack && player.getOffhandItem() != stack) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            this.playerHoldingItem = player;
            this.currentTarget = (Vector3f)stack.get(DSDataComponents.TARGET_POSITION);
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.getGameTime() % 20L == 0L) {
            Pair nearest;
            Optional structure = serverLevel.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(this.target);
            if (structure.isPresent() && (nearest = serverLevel.getChunkSource().getGenerator().findNearestMapStructure(serverLevel, (HolderSet)structure.get(), entity.blockPosition(), 25, false)) != null) {
                SectionPos section = SectionPos.of((BlockPos)((BlockPos)nearest.getFirst()));
                StructureStart start = serverLevel.structureManager().getStartForStructure(section, (Structure)((Holder)nearest.getSecond()).value(), (StructureAccess)serverLevel.getChunk(section.x(), section.z(), ChunkStatus.STRUCTURE_STARTS));
                if (start != null) {
                    stack.set(DSDataComponents.TARGET_POSITION, (Object)start.getBoundingBox().getCenter().getCenter().toVector3f());
                    return;
                }
            }
            stack.set(DSDataComponents.TARGET_POSITION, (Object)this.fake_target);
        } else {
            this.playerHoldingItem = player;
            this.currentTarget = (Vector3f)stack.get(DSDataComponents.TARGET_POSITION);
            String animation = this.currentTarget == this.fake_target || this.currentTarget == null || (double)this.currentTarget.length() < 0.1 ? "no_target" : "idle";
            this.triggerAnim(entity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "rotating_key_controller", animation);
        }
    }
}

